/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serdes.FormattedNumberSerde;

public interface NumberSerde<N extends Number>
extends Serde<N> {
    default public Deserializer<N> createSpecific(Deserializer.DecoderContext decoderContext, Argument<? super N> context) throws SerdeException {
        AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
        String pattern = annotationMetadata.stringValue(SerdeConfig.class, "pattern").orElse(null);
        if (pattern != null) {
            return new FormattedNumberSerde(pattern, annotationMetadata);
        }
        return this;
    }

    default public Serializer<N> createSpecific(Serializer.EncoderContext context, Argument<? extends N> type) {
        AnnotationMetadata annotationMetadata = type.getAnnotationMetadata();
        String pattern = annotationMetadata.stringValue(SerdeConfig.class, "pattern").orElse(null);
        if (pattern != null) {
            return new FormattedNumberSerde(pattern, annotationMetadata);
        }
        return this;
    }
}

