/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.exceptions.SerdeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class JsonNodeEncoder
extends LimitingStream
implements Encoder {
    private JsonNodeEncoder(LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
    }

    @NonNull
    public static JsonNodeEncoder create() {
        return JsonNodeEncoder.create(DEFAULT_LIMITS);
    }

    @NonNull
    @Internal
    public static JsonNodeEncoder create(LimitingStream.RemainingLimits limits) {
        return new Outer(limits);
    }

    protected abstract void encodeValue(JsonNode var1);

    public void encodeString(String value) {
        this.encodeValue(JsonNode.createStringNode((String)value));
    }

    public void encodeBoolean(boolean value) {
        this.encodeValue(JsonNode.createBooleanNode((boolean)value));
    }

    public void encodeByte(byte value) {
        this.encodeValue(JsonNode.createNumberNode((int)value));
    }

    public void encodeShort(short value) {
        this.encodeValue(JsonNode.createNumberNode((int)value));
    }

    public void encodeChar(char value) {
        this.encodeValue(JsonNode.createNumberNode((int)value));
    }

    public void encodeInt(int value) {
        this.encodeValue(JsonNode.createNumberNode((int)value));
    }

    public void encodeLong(long value) {
        this.encodeValue(JsonNode.createNumberNode((long)value));
    }

    public void encodeFloat(float value) {
        this.encodeValue(JsonNode.createNumberNode((float)value));
    }

    public void encodeDouble(double value) {
        this.encodeValue(JsonNode.createNumberNode((double)value));
    }

    public void encodeBigInteger(BigInteger value) {
        this.encodeValue(JsonNode.createNumberNode((BigInteger)value));
    }

    public void encodeBigDecimal(BigDecimal value) {
        this.encodeValue(JsonNode.createNumberNode((BigDecimal)value));
    }

    public void encodeNull() {
        this.encodeValue(JsonNode.nullNode());
    }

    public Encoder encodeArray(Argument<?> type) throws SerdeException {
        return new Array(this, this.childLimits());
    }

    public Encoder encodeObject(Argument<?> type) throws SerdeException {
        return new Obj(this, this.childLimits());
    }

    @NonNull
    public JsonNode getCompletedValue() {
        throw new IllegalStateException("Can only get the completed value of the outermost encoder");
    }

    private static final class Outer
    extends JsonNodeEncoder {
        JsonNode result;

        Outer(LimitingStream.RemainingLimits remainingLimits) {
            super(remainingLimits);
        }

        public void finishStructure() {
            throw new IllegalStateException("Not a structure");
        }

        public void encodeKey(String key) {
            throw new IllegalStateException("Not an object");
        }

        @Override
        protected void encodeValue(JsonNode node) {
            if (this.result != null) {
                throw new IllegalStateException("Already completed");
            }
            this.result = node;
        }

        @Override
        public JsonNode getCompletedValue() {
            if (this.result == null) {
                throw new IllegalStateException("Not completed");
            }
            return this.result;
        }
    }

    private static final class Array
    extends JsonNodeEncoder {
        private final JsonNodeEncoder target;
        private final List<JsonNode> nodes = new ArrayList<JsonNode>();

        Array(JsonNodeEncoder target, LimitingStream.RemainingLimits remainingLimits) {
            super(remainingLimits);
            this.target = target;
        }

        public void finishStructure() {
            this.target.encodeValue(JsonNode.createArrayNode(this.nodes));
        }

        public void encodeKey(String key) {
            throw new IllegalStateException("Arrays don't have keys");
        }

        @Override
        protected void encodeValue(JsonNode node) {
            this.nodes.add(node);
        }
    }

    private static final class Obj
    extends JsonNodeEncoder {
        private final JsonNodeEncoder target;
        private final Map<String, JsonNode> nodes = new LinkedHashMap<String, JsonNode>();
        private String currentKey;

        Obj(JsonNodeEncoder target, LimitingStream.RemainingLimits remainingLimits) {
            super(remainingLimits);
            this.target = target;
        }

        public void finishStructure() {
            this.target.encodeValue(JsonNode.createObjectNode(this.nodes));
        }

        public void encodeKey(String key) {
            if (this.currentKey != null) {
                throw new IllegalStateException("Already have a key");
            }
            this.currentKey = key;
        }

        @Override
        protected void encodeValue(JsonNode node) {
            if (this.currentKey == null) {
                throw new IllegalStateException("Need a key");
            }
            this.nodes.put(this.currentKey, node);
            this.currentKey = null;
        }
    }
}

