/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.support.DeserializerRegistrar;
import io.micronaut.serde.support.deserializers.collect.ArrayDequeDeserializer;
import io.micronaut.serde.support.deserializers.collect.ArrayListDeserializer;
import io.micronaut.serde.support.deserializers.collect.ConvertibleValuesDeserializer;
import io.micronaut.serde.support.deserializers.collect.EnumMapDeserializer;
import io.micronaut.serde.support.deserializers.collect.EnumSetDeserializer;
import io.micronaut.serde.support.deserializers.collect.HashMapDeserializer;
import io.micronaut.serde.support.deserializers.collect.HashSetDeserializer;
import io.micronaut.serde.support.deserializers.collect.LinkedHashMapDeserializer;
import io.micronaut.serde.support.deserializers.collect.LinkedHashSetDeserializer;
import io.micronaut.serde.support.deserializers.collect.LinkedListDeserializer;
import io.micronaut.serde.support.deserializers.collect.SpecificOnlyCollectionDeserializer;
import io.micronaut.serde.support.deserializers.collect.SpecificOnlyMapDeserializer;
import io.micronaut.serde.support.deserializers.collect.StringListDeserializer;
import io.micronaut.serde.support.deserializers.collect.TreeMapDeserializer;
import io.micronaut.serde.support.deserializers.collect.TreeSetDeserializer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;

@Internal
public final class CoreCollectionsDeserializers {
    private static final int PREFERRED_COLLECTION_OR_LIST_ORDER = -100;
    private static final int PREFERRED_DEQUE_ORDER = -99;
    private static final int PREFERRED_SET_ORDER = -98;
    private static final int PREFERRED_MAP_ORDER = -97;

    public static void register(ConversionService conversionService, Consumer<DeserializerRegistrar<?>> consumer) {
        consumer.accept(new StringListDeserializer());
        consumer.accept(new SpecificOnlyCollectionDeserializer<Object, ArrayList<Object>>(ArrayList.class){

            @Override
            protected Deserializer<ArrayList<Object>> createSpecific(Argument<? super ArrayList<Object>> collectionArgument, Argument<Object> collectionItemArgument, Deserializer<?> valueDeser) {
                return new ArrayListDeserializer<Object>(valueDeser, collectionItemArgument);
            }

            public int getOrder() {
                return -100;
            }
        });
        consumer.accept(new SpecificOnlyCollectionDeserializer<Object, ArrayDeque<Object>>(ArrayDeque.class){

            @Override
            protected Deserializer<ArrayDeque<Object>> createSpecific(Argument<? super ArrayDeque<Object>> collectionArgument, Argument<Object> collectionItemArgument, Deserializer<?> valueDeser) {
                return new ArrayDequeDeserializer<Object>(valueDeser, collectionItemArgument);
            }

            public int getOrder() {
                return -99;
            }
        });
        consumer.accept(new SpecificOnlyCollectionDeserializer<Object, LinkedList<Object>>(LinkedList.class){

            @Override
            protected Deserializer<LinkedList<Object>> createSpecific(Argument<? super LinkedList<Object>> collectionArgument, Argument<Object> collectionItemArgument, Deserializer<?> valueDeser) {
                return new LinkedListDeserializer<Object>(valueDeser, collectionItemArgument);
            }
        });
        consumer.accept(new SpecificOnlyCollectionDeserializer<Object, HashSet<Object>>(HashSet.class){

            @Override
            protected Deserializer<HashSet<Object>> createSpecific(Argument<? super HashSet<Object>> collectionArgument, Argument<Object> collectionItemArgument, Deserializer<?> valueDeser) {
                return new HashSetDeserializer<Object>(valueDeser, collectionItemArgument);
            }
        });
        consumer.accept(new SpecificOnlyCollectionDeserializer<Object, LinkedHashSet<Object>>(LinkedHashSet.class){

            @Override
            protected Deserializer<LinkedHashSet<Object>> createSpecific(Argument<? super LinkedHashSet<Object>> collectionArgument, Argument<Object> collectionItemArgument, Deserializer<?> valueDeser) {
                return new LinkedHashSetDeserializer<Object>(valueDeser, collectionItemArgument);
            }

            public int getOrder() {
                return -98;
            }
        });
        consumer.accept(new SpecificOnlyCollectionDeserializer<Object, TreeSet<Object>>(TreeSet.class){

            @Override
            protected Deserializer<TreeSet<Object>> createSpecific(Argument<? super TreeSet<Object>> collectionArgument, Argument<Object> collectionItemArgument, Deserializer<?> valueDeser) {
                return new TreeSetDeserializer<Object>(valueDeser, collectionItemArgument);
            }
        });
        consumer.accept(new SpecificOnlyMapDeserializer<Object, Object, HashMap<Object, Object>>(HashMap.class){

            @Override
            protected Deserializer<HashMap<Object, Object>> createSpecific(Argument<Object> keyType, Argument<Object> valueType, Deserializer<?> valueDeser) {
                return new HashMapDeserializer<Object, Object>(valueDeser, keyType, valueType);
            }
        });
        consumer.accept(new SpecificOnlyMapDeserializer<Object, Object, LinkedHashMap<Object, Object>>(LinkedHashMap.class){

            @Override
            protected Deserializer<LinkedHashMap<Object, Object>> createSpecific(Argument<Object> keyType, Argument<Object> valueType, Deserializer<?> valueDeser) {
                return new LinkedHashMapDeserializer<Object, Object>(valueDeser, keyType, valueType);
            }

            public int getOrder() {
                return -97;
            }
        });
        consumer.accept(new SpecificOnlyMapDeserializer<Object, Object, TreeMap<Object, Object>>(TreeMap.class){

            @Override
            protected Deserializer<TreeMap<Object, Object>> createSpecific(Argument<Object> keyType, Argument<Object> valueType, Deserializer<?> valueDeser) {
                return new TreeMapDeserializer<Object, Object>(valueDeser, keyType, valueType);
            }
        });
        consumer.accept(new EnumSetDeserializer());
        consumer.accept(new EnumMapDeserializer());
        consumer.accept(new ConvertibleValuesDeserializer(conversionService));
    }
}

