/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import java.io.IOException;
import java.util.Map;

@Internal
abstract class MapDeserializer<K, V, M extends Map<K, V>>
implements Deserializer<M> {
    private final Deserializer<? extends V> valueDeser;
    private final Argument<K> keyArgument;
    private final Argument<V> valueArgument;

    MapDeserializer(Deserializer<? extends V> valueDeser, Argument<K> keyArgument, Argument<V> valueArgument) {
        this.valueDeser = valueDeser;
        this.keyArgument = keyArgument;
        this.valueArgument = valueArgument;
    }

    protected final void doDeserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super M> mapType, Map<K, V> map) throws IOException {
        Decoder objectDecoder = decoder.decodeObject(mapType);
        String key = objectDecoder.decodeKey();
        ConversionService conversionService = decoderContext.getConversionService();
        while (key != null) {
            Object k;
            if (this.keyArgument.isInstance((Object)key)) {
                k = key;
            } else {
                try {
                    k = conversionService.convertRequired((Object)key, this.keyArgument);
                }
                catch (ConversionErrorException e) {
                    throw new SerdeException("Error converting Map key [" + key + "] to target type [" + this.keyArgument + "]: " + e.getMessage(), (Throwable)e);
                }
            }
            if (this.valueDeser == null) {
                map.put(k, objectDecoder.decodeArbitrary());
            } else {
                map.put(k, this.valueDeser.deserializeNullable(objectDecoder, decoderContext, this.valueArgument));
            }
            key = objectDecoder.decodeKey();
        }
        objectDecoder.finishStructure();
    }
}

