/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.support.DeserializerRegistrar;
import java.io.IOException;
import java.util.ArrayList;

@Internal
final class StringListDeserializer
implements DeserializerRegistrar<ArrayList<String>> {
    StringListDeserializer() {
    }

    public ArrayList<String> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super ArrayList<String>> type) throws IOException {
        Decoder arrayDecoder = decoder.decodeArray();
        ArrayList<String> collection = new ArrayList<String>();
        while (arrayDecoder.hasNextArrayValue()) {
            collection.add(arrayDecoder.decodeStringNullable());
        }
        arrayDecoder.finishStructure();
        return collection;
    }

    public ArrayList<String> deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super ArrayList<String>> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }

    public ArrayList<String> getDefaultValue(Deserializer.DecoderContext context, Argument<? super ArrayList<String>> type) {
        return new ArrayList<String>();
    }

    @Override
    public Argument<ArrayList<String>> getType() {
        return Argument.of(ArrayList.class, (Class[])new Class[]{String.class});
    }
}

