/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.util.Arrays;

@Internal
final class IntArraySerde
implements SerdeRegistrar<int[]> {
    IntArraySerde() {
    }

    public int[] deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super int[]> type) throws IOException {
        Decoder arrayDecoder = decoder.decodeArray();
        int[] buffer = new int[50];
        int index = 0;
        while (arrayDecoder.hasNextArrayValue()) {
            if (buffer.length == index) {
                buffer = Arrays.copyOf(buffer, buffer.length * 2);
            }
            if (!arrayDecoder.decodeNull()) {
                buffer[index] = arrayDecoder.decodeInt();
            }
            ++index;
        }
        arrayDecoder.finishStructure();
        return Arrays.copyOf(buffer, index);
    }

    public int[] deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super int[]> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type);
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends int[]> type, int[] value) throws IOException {
        Encoder arrayEncoder = encoder.encodeArray(type);
        for (int i : value) {
            arrayEncoder.encodeInt(i);
        }
        arrayEncoder.finishStructure();
    }

    public boolean isEmpty(Serializer.EncoderContext context, int[] value) {
        return value == null || value.length == 0;
    }

    @Override
    public Argument<int[]> getType() {
        return Argument.of(int[].class);
    }
}

