/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.util.CustomizableDeserializer;
import io.micronaut.serde.util.CustomizableSerializer;
import java.io.IOException;
import java.util.Optional;

@Internal
final class OptionalSerde<T>
implements CustomizableSerializer<Optional<T>>,
CustomizableDeserializer<Optional<T>>,
SerdeRegistrar<Optional<T>> {
    OptionalSerde() {
    }

    public Serializer<Optional<T>> createSpecific(Serializer.EncoderContext encoderContext, Argument<? extends Optional<T>> type) throws SerdeException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty((Object[])generics)) {
            throw new SerdeException("Serializing raw optionals is not supported for type: " + type);
        }
        Object generic = generics[0];
        final Serializer componentSerializer = encoderContext.findSerializer((Argument)generic).createSpecific(encoderContext, (Argument)generic);
        return new Serializer<Optional<T>>((Argument)generic){
            final /* synthetic */ Argument val$generic;
            {
                this.val$generic = argument;
            }

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Optional<T>> type, Optional<T> value) throws IOException {
                Object o = value.orElse(null);
                if (o == null) {
                    encoder.encodeNull();
                } else {
                    componentSerializer.serialize(encoder, context, this.val$generic, o);
                }
            }

            public boolean isEmpty(Serializer.EncoderContext context, Optional<T> value) {
                if (value != null && value.isPresent()) {
                    return componentSerializer.isEmpty(context, value.get());
                }
                return true;
            }

            public boolean isAbsent(Serializer.EncoderContext context, Optional<T> value) {
                return value == null || value.isEmpty();
            }
        };
    }

    public Deserializer<Optional<T>> createSpecific(Deserializer.DecoderContext context, Argument<? super Optional<T>> type) throws SerdeException {
        final Argument generic = type.getFirstTypeVariable().orElse(null);
        if (generic == null) {
            throw new SerdeException("Cannot deserialize raw optional");
        }
        final Deserializer deserializer = context.findDeserializer(generic).createSpecific(context, generic);
        return new Deserializer<Optional<T>>(){

            public Optional<T> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Optional<T>> type) throws IOException {
                if (decoder.decodeNull()) {
                    return Optional.empty();
                }
                return Optional.ofNullable(deserializer.deserialize(decoder, context, generic));
            }

            public Optional<T> deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Optional<T>> type) throws IOException {
                return this.deserialize(decoder, context, type);
            }

            public Optional<T> getDefaultValue(Deserializer.DecoderContext context, Argument<? super Optional<T>> type) {
                return Optional.empty();
            }
        };
    }

    @Override
    public Argument<Optional<T>> getType() {
        return Argument.of(Optional.class, (Argument[])new Argument[]{Argument.ofTypeVariable(Object.class, (String)"T")});
    }
}

