/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.GenericPlaceholder;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serializers.CustomizedObjectSerializer;
import io.micronaut.serde.support.serializers.JsonValueSerializer;
import io.micronaut.serde.support.serializers.RuntimeTypeSerializer;
import io.micronaut.serde.support.serializers.SerBean;
import io.micronaut.serde.support.serializers.SerBeanKey;
import io.micronaut.serde.support.serializers.SimpleObjectSerializer;
import io.micronaut.serde.support.serializers.WrappedArraySerializer;
import io.micronaut.serde.support.serializers.WrappedObjectSerializer;
import io.micronaut.serde.support.util.SerdeArgumentConf;
import io.micronaut.serde.support.util.SubtypeInfo;
import io.micronaut.serde.util.CustomizableSerializer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

@Internal
public final class ObjectSerializer
implements CustomizableSerializer<Object> {
    private final SerdeIntrospections introspections;
    private final SerdeConfiguration serdeConfiguration;
    private final SerializationConfiguration serializationConfiguration;
    private final Map<SerBeanKey, Supplier<SerBean<?>>> serBeanMap = new ConcurrentHashMap(50);
    @Nullable
    private final BeanContext beanContext;
    private final ReentrantLock lock = new ReentrantLock();

    public ObjectSerializer(SerdeIntrospections introspections, SerdeConfiguration serdeConfiguration, SerializationConfiguration serializationConfiguration) {
        this(introspections, serdeConfiguration, serializationConfiguration, null);
    }

    public ObjectSerializer(SerdeIntrospections introspections, SerdeConfiguration serdeConfiguration, SerializationConfiguration serializationConfiguration, @Nullable BeanContext beanContext) {
        this.introspections = introspections;
        this.serdeConfiguration = serdeConfiguration;
        this.serializationConfiguration = serializationConfiguration;
        this.beanContext = beanContext;
    }

    @Deprecated(since="2.9", forRemoval=true)
    public ObjectSerializer(SerdeIntrospections introspections, BeanContext beanContext) {
        this(introspections, (SerdeConfiguration)beanContext.getBean(SerdeConfiguration.class), (SerializationConfiguration)beanContext.getBean(SerializationConfiguration.class));
    }

    public Serializer<Object> createSpecific(@NonNull Serializer.EncoderContext encoderContext, Argument<?> type) throws SerdeException {
        boolean isObjectType = type.equalsType(Argument.OBJECT_ARGUMENT);
        if (isObjectType || type instanceof GenericPlaceholder) {
            Serializer<Object> outer = !isObjectType ? this.createSpecificInternal(encoderContext, type) : null;
            return new RuntimeTypeSerializer(encoderContext, outer, type);
        }
        return this.createSpecificInternal(encoderContext, type);
    }

    private Serializer<Object> createSpecificInternal(Serializer.EncoderContext encoderContext, Argument<?> type) throws SerdeException {
        SerBean<?> serBean;
        try {
            serBean = this.getSerializableBean(type, encoderContext);
        }
        catch (IntrospectionException e) {
            return new RuntimeTypeSerializer(encoderContext, e, type);
        }
        Object serializer = serBean.simpleBean ? new SimpleObjectSerializer(serBean) : (serBean.jsonValue != null ? new JsonValueSerializer(serBean.jsonValue) : new CustomizedObjectSerializer(serBean));
        if (serBean.subtyped) {
            serializer = new RuntimeTypeSerializer(encoderContext, (Serializer<Object>)serializer, type);
        } else if (serBean.wrapperProperty != null) {
            serializer = new WrappedObjectSerializer((Serializer<?>)serializer, serBean.wrapperProperty);
        } else if (serBean.arrayWrapperProperty != null) {
            serializer = new WrappedArraySerializer((Serializer<?>)serializer, serBean.arrayWrapperProperty);
        } else {
            SubtypeInfo subtypeInfo = serBean.subtypeInfo;
            if (subtypeInfo != null) {
                String[] names;
                if (subtypeInfo.discriminatorType() == SerdeConfig.SerSubtyped.DiscriminatorType.WRAPPER_OBJECT && (names = subtypeInfo.subtypes().get(type.getType())) != null) {
                    serializer = new WrappedObjectSerializer(serializer, names[0]);
                }
                if (subtypeInfo.discriminatorType() == SerdeConfig.SerSubtyped.DiscriminatorType.WRAPPER_ARRAY && (names = subtypeInfo.subtypes().get(type.getType())) != null) {
                    serializer = new WrappedArraySerializer(serializer, names[0]);
                }
            }
        }
        return serializer;
    }

    private <T> SerBean<T> getSerializableBean(Argument<T> type, Serializer.EncoderContext context) throws SerdeException {
        AnnotationMetadata annotationMetadata = type.getAnnotationMetadata();
        SerdeArgumentConf serdeArgumentConf = annotationMetadata.isEmpty() ? null : new SerdeArgumentConf(annotationMetadata);
        SerBeanKey key = new SerBeanKey(context.getSerdeConfiguration().orElse(this.serdeConfiguration), context.getSerializationConfiguration().orElse(this.serializationConfiguration), type, serdeArgumentConf);
        Supplier serBeanSupplier = this.serBeanMap.computeIfAbsent(key, ignore -> SupplierUtil.memoizedNonEmpty(() -> {
            try {
                return new SerBean(type, this.introspections, context, serdeArgumentConf, this.serializationConfiguration, this.beanContext);
            }
            catch (SerdeException e) {
                throw new IntrospectionException("Error creating deserializer for type [" + type + "]: " + e.getMessage(), (Throwable)e);
            }
        }));
        SerBean serBean = (SerBean)serBeanSupplier.get();
        serBean.initialize(this.lock, context);
        return serBean;
    }
}

