/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerializerRegistrar;
import io.micronaut.serde.util.CustomizableSerializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.stream.Stream;

@Internal
final class StreamSerializer<T>
implements CustomizableSerializer<Stream<T>>,
SerializerRegistrar<Stream<T>> {
    StreamSerializer() {
    }

    public Serializer<Stream<T>> createSpecific(Serializer.EncoderContext context, Argument<? extends Stream<T>> type) throws SerdeException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty((Object[])generics)) {
            throw new SerdeException("Cannot serialize raw stream");
        }
        Object generic = generics[0];
        final Serializer componentSerializer = context.findSerializer((Argument)generic).createSpecific(context, type);
        return new Serializer<Stream<T>>(){
            final /* synthetic */ Argument val$generic;
            {
                this.val$generic = argument;
            }

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Stream<T>> type, Stream<T> value) throws IOException {
                if (value == null) {
                    throw new SerdeException("Stream is required");
                }
                Encoder arrayEncoder = encoder.encodeArray(type);
                Iterator itr = value.iterator();
                while (itr.hasNext()) {
                    componentSerializer.serialize(arrayEncoder, context, this.val$generic, itr.next());
                }
                arrayEncoder.finishStructure();
            }
        };
    }

    @Override
    public Argument<Stream<T>> getType() {
        return Argument.of(Stream.class, (Argument[])new Argument[]{Argument.ofTypeVariable(Object.class, (String)"T")});
    }
}

