/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

@Internal
final class JsonNodeSerde
implements SerdeRegistrar<JsonNode> {
    JsonNodeSerde() {
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends JsonNode> type, JsonNode value) throws IOException {
        this.serialize0(encoder, value);
    }

    private void serialize0(Encoder encoder, JsonNode value) throws IOException {
        if (value == null) {
            value = JsonNode.nullNode();
        }
        if (value.isNull()) {
            encoder.encodeNull();
        } else if (value.isBoolean()) {
            encoder.encodeBoolean(value.getBooleanValue());
        } else if (value.isString()) {
            encoder.encodeString(value.getStringValue());
        } else if (value.isNumber()) {
            Number numberValue = value.getNumberValue();
            if (numberValue instanceof Integer) {
                encoder.encodeInt(numberValue.intValue());
            } else if (numberValue instanceof Long) {
                encoder.encodeLong(numberValue.longValue());
            } else if (numberValue instanceof Short) {
                encoder.encodeShort(numberValue.shortValue());
            } else if (numberValue instanceof Byte) {
                encoder.encodeByte(numberValue.byteValue());
            } else if (numberValue instanceof BigInteger) {
                BigInteger bi = (BigInteger)numberValue;
                encoder.encodeBigInteger(bi);
            } else if (numberValue instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)numberValue;
                encoder.encodeBigDecimal(bd);
            } else {
                encoder.encodeDouble(numberValue.doubleValue());
            }
        } else if (value.isObject()) {
            Encoder objectEncoder = encoder.encodeObject(Argument.of(JsonNode.class));
            for (Map.Entry entry : value.entries()) {
                objectEncoder.encodeKey((String)entry.getKey());
                this.serialize0(encoder, (JsonNode)entry.getValue());
            }
            objectEncoder.finishStructure();
        } else if (value.isArray()) {
            Encoder arrayEncoder = encoder.encodeArray(Argument.of(JsonNode.class));
            for (JsonNode entry : value.values()) {
                this.serialize0(encoder, entry);
            }
            arrayEncoder.finishStructure();
        } else {
            throw new IllegalArgumentException("Unsupported JSON node");
        }
    }

    public JsonNode deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super JsonNode> type) throws IOException {
        return decoder.decodeNode();
    }

    @Override
    public Argument<JsonNode> getType() {
        return Argument.of(JsonNode.class);
    }
}

