/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.DeserializerRegistrar;
import io.micronaut.serde.util.CustomizableDeserializer;
import java.io.IOException;
import java.util.Map;

@Internal
abstract class SpecificOnlyMapDeserializer<K, V, M extends Map<K, V>>
implements CustomizableDeserializer<M>,
DeserializerRegistrar<M> {
    private final Class<? extends Map> type;

    SpecificOnlyMapDeserializer(Class<? extends Map> type) {
        this.type = type;
    }

    public Deserializer<M> createSpecific(Deserializer.DecoderContext context, Argument<? super M> type) throws SerdeException {
        Argument[] generics = type.getTypeParameters();
        if (generics.length == 2) {
            Argument keyType = generics[0];
            Argument valueType = generics[1];
            Deserializer valueDeser = valueType.equalsType(Argument.OBJECT_ARGUMENT) ? null : context.findDeserializer(valueType).createSpecific(context, valueType);
            return this.createSpecific(keyType, valueType, valueDeser);
        }
        return new Deserializer<M>(){

            public M deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super M> type) throws IOException {
                Object o = decoder.decodeArbitrary();
                if (type.isInstance(o)) {
                    return (Map)o;
                }
                if (o instanceof Map) {
                    Map map = (Map)this.getDefaultValue(decoderContext, type);
                    map.putAll((Map)o);
                    return map;
                }
                throw new SerdeException("Cannot deserialize map of type [" + String.valueOf(type) + "] from value: " + String.valueOf(o));
            }
        };
    }

    @NonNull
    protected abstract Deserializer<M> createSpecific(Argument<K> var1, Argument<V> var2, Deserializer<? extends V> var3);

    @Override
    public Argument<M> getType() {
        return Argument.of(this.type, (Argument[])new Argument[]{Argument.ofTypeVariable(Object.class, (String)"K"), Argument.ofTypeVariable(Object.class, (String)"V")});
    }
}

