/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerializerRegistrar;
import io.micronaut.serde.support.util.JsonNodeEncoder;
import io.micronaut.serde.util.CustomizableSerializer;
import java.io.IOException;
import java.util.Map;

@Internal
final class CustomizedMapSerializer<K, V>
implements CustomizableSerializer<Map<K, V>>,
SerializerRegistrar<Map<K, V>> {
    CustomizedMapSerializer() {
    }

    public ObjectSerializer<Map<K, V>> createSpecific(Serializer.EncoderContext context, Argument<? extends Map<K, V>> type) throws SerdeException {
        boolean hasGenerics;
        Object[] generics = type.getTypeParameters();
        boolean bl = hasGenerics = ArrayUtils.isNotEmpty((Object[])generics) && generics.length == 2;
        if (hasGenerics) {
            Object keyGeneric = generics[0];
            Serializer<K> keySerializer = this.findKeySerializer(context, (Argument<K>)keyGeneric);
            final boolean isStringKey = keyGeneric.getType().equals(String.class) || CharSequence.class.isAssignableFrom(keyGeneric.getType());
            Object valueGeneric = generics[1];
            Serializer valSerializer = context.findSerializer((Argument)valueGeneric).createSpecific(context, (Argument)valueGeneric);
            return new ObjectSerializer<Map<K, V>>((Argument)keyGeneric, keySerializer, valSerializer, (Argument)valueGeneric){
                final /* synthetic */ Argument val$keyGeneric;
                final /* synthetic */ Serializer val$keySerializer;
                final /* synthetic */ Serializer val$valSerializer;
                final /* synthetic */ Argument val$valueGeneric;
                {
                    this.val$keyGeneric = argument;
                    this.val$keySerializer = serializer;
                    this.val$valSerializer = serializer2;
                    this.val$valueGeneric = argument2;
                }

                public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                    Encoder objectEncoder = encoder.encodeObject(type);
                    this.serializeInto(objectEncoder, context, type, value);
                    objectEncoder.finishStructure();
                }

                public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                    for (Map.Entry entry : value.entrySet()) {
                        Object k = entry.getKey();
                        if (k == null) {
                            encoder.encodeNull();
                        } else if (isStringKey) {
                            encoder.encodeKey(k.toString());
                        } else {
                            CustomizedMapSerializer.this.encodeMapKey(context, encoder, this.val$keyGeneric, this.val$keySerializer, k);
                        }
                        Object v = entry.getValue();
                        if (v == null) {
                            encoder.encodeNull();
                            continue;
                        }
                        this.val$valSerializer.serialize(encoder, context, this.val$valueGeneric, v);
                    }
                }

                public boolean isEmpty(Serializer.EncoderContext context, Map<K, V> value) {
                    return CollectionUtils.isEmpty(value);
                }
            };
        }
        return new ObjectSerializer<Map<K, V>>(){

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                Encoder childEncoder = encoder.encodeObject(type);
                this.serializeInto(childEncoder, context, type, value);
                childEncoder.finishStructure();
            }

            public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
                Argument keyGeneric = null;
                Serializer keySerializer = null;
                Argument valueGeneric = null;
                Serializer valSerializer = null;
                for (Map.Entry entry : value.entrySet()) {
                    Object k = entry.getKey();
                    if (k instanceof CharSequence) {
                        encoder.encodeKey(k.toString());
                    } else {
                        if (keyGeneric == null || !keyGeneric.getType().equals(k.getClass())) {
                            keyGeneric = Argument.of(k.getClass());
                            keySerializer = CustomizedMapSerializer.this.findKeySerializer(context, keyGeneric);
                        }
                        CustomizedMapSerializer.this.encodeMapKey(context, encoder, keyGeneric, keySerializer, k);
                    }
                    Object v = entry.getValue();
                    if (v == null) {
                        encoder.encodeNull();
                        continue;
                    }
                    if (valueGeneric == null || !valueGeneric.getType().equals(v.getClass())) {
                        valueGeneric = Argument.of(v.getClass());
                        valSerializer = context.findSerializer(valueGeneric).createSpecific(context, valueGeneric);
                    }
                    valSerializer.serialize(encoder, context, valueGeneric, v);
                }
            }

            public boolean isEmpty(Serializer.EncoderContext context, Map<K, V> value) {
                return CollectionUtils.isEmpty(value);
            }
        };
    }

    private Serializer<K> findKeySerializer(Serializer.EncoderContext context, Argument<K> keyGeneric) throws SerdeException {
        try {
            return context.findSerializer(keyGeneric).createSpecific(context, keyGeneric);
        }
        catch (SerdeException e) {
            if (e.getCause() instanceof IntrospectionException) {
                return (encoder, ctx, type, value) -> this.convertMapKeyToStringAndEncode(ctx, encoder, value);
            }
            throw e;
        }
    }

    private void encodeMapKey(Serializer.EncoderContext context, Encoder encoder, Argument<K> keyGeneric, Serializer<? super K> keySerializer, K k) throws IOException {
        JsonNodeEncoder keyEncoder = JsonNodeEncoder.create();
        try {
            keySerializer.serialize((Encoder)keyEncoder, context, keyGeneric, k);
        }
        catch (SerdeException e) {
            if (e.getCause() instanceof IntrospectionException) {
                this.convertMapKeyToStringAndEncode(context, encoder, k);
                return;
            }
            throw e;
        }
        JsonNode keyNode = keyEncoder.getCompletedValue();
        if (keyNode.isString()) {
            encoder.encodeKey(keyNode.getStringValue());
        } else {
            if (keyNode.isNull()) {
                throw new SerdeException("Null key for a Map not allowed in JSON");
            }
            if (keyNode.isBoolean() || keyNode.isNumber()) {
                encoder.encodeKey(keyNode.coerceStringValue());
            } else {
                this.convertMapKeyToStringAndEncode(context, encoder, keyNode.getValue());
            }
        }
    }

    private void convertMapKeyToStringAndEncode(Serializer.EncoderContext context, Encoder encoder, Object keyValue) throws IOException {
        try {
            String result = (String)context.getConversionService().convertRequired(keyValue, Argument.STRING);
            if (result == null) {
                throw new SerdeException("Null key for a Map not allowed in JSON");
            }
            encoder.encodeKey(result);
        }
        catch (ConversionErrorException ce) {
            throw new SerdeException("Error converting Map key [" + String.valueOf(keyValue) + "] to String: " + ce.getMessage(), (Throwable)ce);
        }
    }

    @Override
    public Argument<Map<K, V>> getType() {
        return Argument.mapOf((Argument)Argument.ofTypeVariable(Object.class, (String)"K"), (Argument)Argument.ofTypeVariable(Object.class, (String)"V"));
    }
}

