/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import java.io.IOException;
import java.util.Map;

@Internal
final class WrappedObjectSubtypedDeserializer
implements Deserializer<Object> {
    private final Map<String, Deserializer<Object>> subtypes;
    private final boolean ignoreUnknown;

    WrappedObjectSubtypedDeserializer(Map<String, Deserializer<Object>> subtypes, boolean ignoreUnknown) {
        this.subtypes = subtypes;
        this.ignoreUnknown = ignoreUnknown;
    }

    public Object deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Object> type) throws IOException {
        return this.deserialize(decoder, context, type, false);
    }

    public Object deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Object> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, type, true);
    }

    private Object deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super Object> type, boolean isNullable) throws IOException {
        Decoder unwrappedDecoder = decoder.decodeObject();
        String key = unwrappedDecoder.decodeKey();
        if (key == null) {
            if (isNullable) {
                return null;
            }
            throw new SerdeException("Wrapper property is null encountered during deserialization of type: " + String.valueOf(type));
        }
        Deserializer<Object> deserializer = this.subtypes.get(key);
        if (deserializer == null) {
            throw new SerdeException("Unknown wrapper property: [" + key + "] encountered during deserialization of type: " + String.valueOf(type));
        }
        Object result = isNullable ? deserializer.deserializeNullable(unwrappedDecoder, context, type) : deserializer.deserialize(unwrappedDecoder, context, type);
        if (this.ignoreUnknown) {
            unwrappedDecoder.finishStructure(true);
        } else {
            String unknownProp = unwrappedDecoder.decodeKey();
            if (unknownProp != null) {
                throw this.unknownProperty(type, unknownProp);
            }
            unwrappedDecoder.finishStructure();
        }
        return result;
    }

    private SerdeException unknownProperty(Argument<? super Object> beanType, String prop) {
        return new SerdeException("Unknown property [" + prop + "] encountered during deserialization of type: " + String.valueOf(beanType));
    }
}

