/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.support.serdes.NumberSerde;
import java.io.IOException;
import java.util.Arrays;

@Internal
final class ShortSerde
implements SerdeRegistrar<Short>,
NumberSerde<Short> {
    ShortSerde() {
    }

    public Short deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Short> type) throws IOException {
        return decoder.decodeShort();
    }

    public Short deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Short> type) throws IOException {
        return decoder.decodeShortNullable();
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Short> type, Short value) throws IOException {
        encoder.encodeShort(value.shortValue());
    }

    public boolean isDefault(Serializer.EncoderContext context, Short value) {
        return value.equals((short)0);
    }

    @Override
    public Argument<Short> getType() {
        return Argument.of(Short.class);
    }

    @Override
    public Iterable<Argument<?>> getTypes() {
        return Arrays.asList(this.getType(), Argument.SHORT);
    }

    @Nullable
    public Short getDefaultValue(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super Short> type) {
        return type.isPrimitive() ? Short.valueOf((short)0) : null;
    }
}

