/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.UpdatingDeserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.ErrorCatchingDeserializer;
import java.io.IOException;

@Internal
final class ErrorCatchingUpdatingDeserializer<T>
extends ErrorCatchingDeserializer<T>
implements UpdatingDeserializer<T> {
    private final UpdatingDeserializer<T> deserializer;

    ErrorCatchingUpdatingDeserializer(UpdatingDeserializer<T> deserializer) {
        super(deserializer);
        this.deserializer = deserializer;
    }

    public void deserializeInto(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super T> type, T value) throws IOException {
        try {
            this.deserializer.deserializeInto(decoder, decoderContext, type, value);
        }
        catch (StackOverflowError e) {
            throw new SerdeException("Infinite recursion deserializing type: " + String.valueOf(type), (Throwable)e);
        }
        catch (IntrospectionException e) {
            throw new SerdeException("Error deserializing. No deserializing found for type: " + String.valueOf(type), (Throwable)e);
        }
        catch (SerdeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerdeException("Error deserializing value: " + String.valueOf(value) + " of type: " + String.valueOf(type), (Throwable)e);
        }
    }
}

