/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.support.deserializers.DemuxingObjectDecoder;
import io.micronaut.serde.support.deserializers.DeserBeanSubtypeInfo;
import io.micronaut.serde.support.deserializers.DeserializerSubtypeInfo;
import java.io.IOException;

@Internal
final class SubtypedPropertyObjectDeserializer
implements Deserializer<Object> {
    private final DeserializerSubtypeInfo<? super Object> subtypeInfo;

    public SubtypedPropertyObjectDeserializer(DeserializerSubtypeInfo<? super Object> subtypeInfo) {
        this.subtypeInfo = subtypeInfo;
        SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType = subtypeInfo.parent().info().discriminatorType();
        if (discriminatorType != SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY && discriminatorType != SerdeConfig.SerSubtyped.DiscriminatorType.EXISTING_PROPERTY) {
            throw new IllegalStateException("Unsupported discriminator type: " + String.valueOf(discriminatorType));
        }
    }

    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
        try (DemuxingObjectDecoder.PrimedDecoder primed = DemuxingObjectDecoder.prime(decoder);){
            DemuxingObjectDecoder typeFinder = this.subtypeInfo.parent().info().discriminatorVisible() ? primed.decodeObjectNonConsuming(type) : primed.decodeObject(type);
            Deserializer<? super Object> deserializer = this.findDeserializer((Decoder)typeFinder);
            typeFinder.finishStructure(true);
            Object object = deserializer.deserialize((Decoder)primed, decoderContext, type);
            return object;
        }
    }

    @NonNull
    private Deserializer<? super Object> findDeserializer(Decoder objectDecoder) throws IOException {
        String key;
        DeserBeanSubtypeInfo<? super Object> deserBeanSubtypeInfo = this.subtypeInfo.parent();
        String discriminatorName = deserBeanSubtypeInfo.info().discriminatorName();
        while ((key = objectDecoder.decodeKey()) != null) {
            if (key.equals(discriminatorName)) {
                if (objectDecoder.decodeNull()) {
                    return this.subtypeInfo.findDeserializer(null);
                }
                String discriminatorValue = objectDecoder.decodeString();
                return this.subtypeInfo.findDeserializer(discriminatorValue);
            }
            objectDecoder.skipValue();
        }
        return this.subtypeInfo.findDeserializer(null);
    }
}

