/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;

@Internal
final class StringSerde
implements SerdeRegistrar<String> {
    StringSerde() {
    }

    @Override
    public Argument<String> getType() {
        return Argument.of(String.class);
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends String> type, String value) throws IOException {
        encoder.encodeString(value);
    }

    public String deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super String> type) throws IOException {
        return decoder.decodeString();
    }

    public String deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super String> type) throws IOException {
        return decoder.decodeStringNullable();
    }

    public boolean isEmpty(Serializer.EncoderContext context, String value) {
        return value == null || value.isEmpty();
    }
}

