/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.value.OptionalMultiValues;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.exceptions.path.ReferencePath;
import io.micronaut.serde.support.SerializerRegistrar;
import io.micronaut.serde.util.CustomizableSerializer;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Internal
final class OptionalMultiValuesSerializer<V>
implements CustomizableSerializer<OptionalMultiValues<V>>,
SerializerRegistrar<OptionalMultiValues<V>> {
    private final boolean alwaysSerializeErrorsAsList;

    public OptionalMultiValuesSerializer(SerializationConfiguration jacksonConfiguration) {
        this.alwaysSerializeErrorsAsList = jacksonConfiguration.isAlwaysSerializeErrorsAsList();
    }

    public ObjectSerializer<OptionalMultiValues<V>> createSpecific(final Serializer.EncoderContext context, Argument<? extends OptionalMultiValues<V>> type) throws SerdeException {
        boolean alwaysSerializeErrorsAsList = context.getSerializationConfiguration().map(SerializationConfiguration::isAlwaysSerializeErrorsAsList).orElse(this.alwaysSerializeErrorsAsList);
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty((Object[])generics)) {
            throw new SerdeException("Cannot serialize raw OptionalMultiValues");
        }
        Object generic = generics[0];
        final Argument listGeneric = Argument.listOf((Argument)generic);
        return new ObjectSerializer<OptionalMultiValues<V>>((Argument)generic, alwaysSerializeErrorsAsList){
            Serializer<Object> listSerializer;
            Serializer<Object> valueSerializer;
            final /* synthetic */ Argument val$generic;
            final /* synthetic */ boolean val$alwaysSerializeErrorsAsList;
            {
                this.val$generic = argument2;
                this.val$alwaysSerializeErrorsAsList = bl;
                this.listSerializer = context.findSerializer(listGeneric).createSpecific(context, listGeneric);
                this.valueSerializer = context.findSerializer(this.val$generic).createSpecific(context, this.val$generic);
            }

            public void serializeInto(Encoder encoder, Serializer.EncoderContext context2, Argument<? extends OptionalMultiValues<V>> type, OptionalMultiValues<V> value) throws IOException {
                for (CharSequence key : value) {
                    try {
                        Optional opt = value.get(key);
                        if (!opt.isPresent()) continue;
                        String fieldName = key.toString();
                        encoder.encodeKey(fieldName);
                        List list = (List)opt.get();
                        if (this.val$alwaysSerializeErrorsAsList) {
                            this.listSerializer.serialize(encoder, context2, listGeneric, (Object)list);
                            continue;
                        }
                        if (list.size() == 1) {
                            this.valueSerializer.serialize(encoder, context2, this.val$generic, list.get(0));
                            continue;
                        }
                        this.listSerializer.serialize(encoder, context2, listGeneric, (Object)list);
                    }
                    catch (SerdeException e) {
                        e.getPath().add(ReferencePath.ofMap(value.getClass(), type, (String)key.toString()));
                        throw e;
                    }
                }
            }

            public void serialize(Encoder encoder, Serializer.EncoderContext context2, Argument<? extends OptionalMultiValues<V>> type, OptionalMultiValues<V> value) throws IOException {
                Objects.requireNonNull(value, "Values can't be null");
                Encoder objectEncoder = encoder.encodeObject(type);
                this.serializeInto(encoder, context2, type, value);
                objectEncoder.finishStructure();
            }

            public boolean isEmpty(Serializer.EncoderContext context2, OptionalMultiValues<V> value) {
                return value == null || value.isEmpty();
            }
        };
    }

    @Override
    public Argument<OptionalMultiValues<V>> getType() {
        return Argument.of(OptionalMultiValues.class, (Argument[])new Argument[]{Argument.ofTypeVariable(Object.class, (String)"V")});
    }
}

