/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.util;

import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
public record SubtypeInfo(@NonNull Map<Class<?>, String[]> subtypes, @NonNull SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType, @NonNull String discriminatorName, @Nullable Class<?> defaultImpl, boolean discriminatorVisible, boolean deduct) {
    public static SubtypeInfo createForProperty(AnnotationMetadata annotationMetadata) {
        return SubtypeInfo.create(annotationMetadata, false);
    }

    public static SubtypeInfo createForType(AnnotationMetadata annotationMetadata) {
        return SubtypeInfo.create(annotationMetadata, true);
    }

    private static SubtypeInfo create(AnnotationMetadata annotationMetadata, boolean isClassDefinition) {
        if (!annotationMetadata.hasAnnotation(SerdeConfig.SerSubtyped.class)) {
            return null;
        }
        SerdeConfig.SerSubtyped.DiscriminatorType discriminatorType = annotationMetadata.enumValue(SerdeConfig.SerSubtyped.class, "dt", SerdeConfig.SerSubtyped.DiscriminatorType.class).orElse(SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY);
        if (isClassDefinition && discriminatorType == SerdeConfig.SerSubtyped.DiscriminatorType.EXTERNAL_PROPERTY) {
            discriminatorType = SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY;
        }
        SerdeConfig.SerSubtyped.DiscriminatorValueKind discriminatorValue = annotationMetadata.enumValue(SerdeConfig.SerSubtyped.class, "dv", SerdeConfig.SerSubtyped.DiscriminatorValueKind.class).orElse(SerdeConfig.SerSubtyped.DiscriminatorValueKind.CLASS_NAME);
        String discriminatorName = annotationMetadata.stringValue(SerdeConfig.SerSubtyped.class, "dp").orElse(discriminatorValue == SerdeConfig.SerSubtyped.DiscriminatorValueKind.CLASS_NAME ? "@class" : "@type");
        List subtypesAnn = annotationMetadata.getAnnotationValuesByType(SerdeConfig.SerSubtyped.SerSubtype.class);
        Class defaultType = annotationMetadata.classValue(DefaultImplementation.class).orElseGet(() -> annotationMetadata.classValue("defaultImpl").orElse(null));
        HashMap subtypes = CollectionUtils.newHashMap((int)subtypesAnn.size());
        for (AnnotationValue subtype : subtypesAnn) {
            Optional type = subtype.classValue();
            if (!type.isPresent()) continue;
            Class subtypeClass = (Class)type.get();
            String[] names = subtype.stringValues("names");
            if (names.length == 0) continue;
            subtypes.put(subtypeClass, names);
        }
        return new SubtypeInfo(subtypes, discriminatorType, discriminatorName, defaultType, annotationMetadata.booleanValue(SerdeConfig.SerSubtyped.class, "discriminatorVisible").orElse(false), discriminatorValue == SerdeConfig.SerSubtyped.DiscriminatorValueKind.DEDUCTION);
    }
}

