/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.support.deserializers.collect.CollectionDeserializer;
import java.io.IOException;
import java.util.LinkedList;

final class LinkedListDeserializer<E>
extends CollectionDeserializer<E, LinkedList<E>> {
    LinkedListDeserializer(Deserializer<? extends E> valueDeser, Argument<E> collectionItemArgument) {
        super(valueDeser, collectionItemArgument);
    }

    public LinkedList<E> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super LinkedList<E>> type) throws IOException {
        LinkedList collection = new LinkedList();
        this.doDeserialize(decoder, context, collection);
        return collection;
    }

    public LinkedList<E> deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super LinkedList<E>> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }

    public LinkedList<E> getDefaultValue(Deserializer.DecoderContext context, Argument<? super LinkedList<E>> type) {
        return new LinkedList();
    }
}

