/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serdes.InstantSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.Instant;

@Singleton
@Secondary
final class SqlTimestampSerde
implements Serde<Timestamp> {
    private static final Argument<Instant> INSTANT_ARGUMENT = Argument.of(Instant.class);
    private final InstantSerde instantSerde;

    SqlTimestampSerde(InstantSerde instantSerde) {
        this.instantSerde = instantSerde;
    }

    public Serializer<Timestamp> createSpecific(Serializer.EncoderContext encoderContext, Argument<? extends Timestamp> type) {
        Argument argument = Argument.of(Instant.class, (AnnotationMetadata)type.getAnnotationMetadata(), (Argument[])new Argument[0]);
        Serializer specific = this.instantSerde.createSpecific(encoderContext, argument);
        if (specific != this.instantSerde) {
            return (encoder, context, t, value) -> specific.serialize(encoder, context, argument, (Object)value.toInstant());
        }
        return this;
    }

    public Deserializer<Timestamp> createSpecific(Deserializer.DecoderContext decoderContext, Argument<? super Timestamp> context) throws SerdeException {
        Argument argument = Argument.of(Instant.class, (AnnotationMetadata)context.getAnnotationMetadata(), (Argument[])new Argument[0]);
        Deserializer specific = this.instantSerde.createSpecific(decoderContext, argument);
        if (specific != this.instantSerde) {
            return (decoder, subContext, type) -> {
                Instant i = (Instant)specific.deserialize(decoder, subContext, argument);
                if (i != null) {
                    return Timestamp.from(i);
                }
                return null;
            };
        }
        return this;
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Timestamp> type, Timestamp value) throws IOException {
        this.instantSerde.serialize(encoder, context, INSTANT_ARGUMENT, value.toInstant());
    }

    public Timestamp deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Timestamp> type) throws IOException {
        return Timestamp.from((Instant)this.instantSerde.deserialize(decoder, decoderContext, (Argument)INSTANT_ARGUMENT));
    }
}

