/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.naming.Named;
import io.micronaut.serde.support.deserializers.DeserBean;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class PropertiesBag<T> {
    private final BeanIntrospection<T> beanIntrospection;
    private final int[] originalNameToPropertiesMapping;
    private final DeserBean.DerProperty<T, Object>[] properties;
    @Nullable
    private final Map<String, Integer> nameToPropertiesMapping;
    private final long propertiesMask;
    private final String[] keyTable;
    private final int[] indexTable;
    private final int tableMask;

    private PropertiesBag(BeanIntrospection<T> beanIntrospection, int[] originalNameToPropertiesMapping, DeserBean.DerProperty<T, Object>[] properties, Map<String, Integer> nameToPropertiesMapping) {
        this.beanIntrospection = beanIntrospection;
        this.originalNameToPropertiesMapping = originalNameToPropertiesMapping;
        this.properties = properties;
        this.nameToPropertiesMapping = nameToPropertiesMapping;
        this.propertiesMask = properties.length > 0 && properties.length <= 64 ? -1L >>> 64 - properties.length : 0L;
        Stream<String> propStream = beanIntrospection.getBeanProperties().stream().map(Named::getName);
        if (nameToPropertiesMapping != null) {
            propStream = Stream.concat(propStream, nameToPropertiesMapping.keySet().stream());
        }
        Set props = propStream.collect(Collectors.toSet());
        int tableSize = props.size() * 2 + 1;
        tableSize = Integer.highestOneBit(tableSize) * 2;
        this.tableMask = tableSize - 1;
        this.keyTable = new String[tableSize];
        this.indexTable = new int[this.keyTable.length];
        for (String prop : props) {
            int tableIndex = ~this.probe(prop);
            this.keyTable[tableIndex] = prop;
            this.indexTable[tableIndex] = this.propertyIndexOfSlow(prop);
        }
    }

    private int probe(String key) {
        int n = this.keyTable.length;
        int i = key.hashCode() & this.tableMask;
        String candidate;
        while ((candidate = this.keyTable[i]) != null) {
            if (candidate.equals(key)) {
                return i;
            }
            if (++i != n) continue;
            i = 0;
        }
        return ~i;
    }

    public List<Map.Entry<String, DeserBean.DerProperty<T, Object>>> getProperties() {
        Stream<AbstractMap.SimpleEntry> originalProperties = Arrays.stream(this.originalNameToPropertiesMapping).filter(index -> index != -1).mapToObj(index -> {
            DeserBean.DerProperty<T, Object> prop = this.properties[index];
            if (prop.beanProperty == null) {
                return null;
            }
            return new AbstractMap.SimpleEntry<String, DeserBean.DerProperty<T, Object>>(prop.beanProperty.getName(), prop);
        });
        Stream mappedByName = this.nameToPropertiesMapping == null ? Stream.empty() : this.nameToPropertiesMapping.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, DeserBean.DerProperty<T, Object>>((String)e.getKey(), this.properties[(Integer)e.getValue()]));
        return Stream.concat(originalProperties, mappedByName).collect(Collectors.toList());
    }

    public List<DeserBean.DerProperty<T, Object>> getDerProperties() {
        return Collections.unmodifiableList(Arrays.asList(this.properties));
    }

    public DeserBean.DerProperty<T, Object>[] getPropertiesArray() {
        return this.properties;
    }

    public int propertyIndexOf(@NonNull String name) {
        int i = this.probe(name);
        return i < 0 ? -1 : this.indexTable[i];
    }

    private int propertyIndexOfSlow(@NonNull String name) {
        int propertyIndex = -1;
        int beanPropertyIndex = this.beanIntrospection.propertyIndexOf(name);
        if (beanPropertyIndex != -1) {
            propertyIndex = this.originalNameToPropertiesMapping[beanPropertyIndex];
        }
        if (propertyIndex != -1) {
            return propertyIndex;
        }
        return this.nameToPropertiesMapping == null ? -1 : this.nameToPropertiesMapping.getOrDefault(name, -1);
    }

    public Consumer newConsumer() {
        return this.propertiesMask == 0L ? new ConsumerBig() : new ConsumerSmall();
    }

    private final class ConsumerBig
    extends Consumer {
        private final BitSet consumed;
        private int remaining;

        private ConsumerBig() {
            this.consumed = new BitSet(PropertiesBag.this.properties.length);
            this.remaining = PropertiesBag.this.properties.length;
        }

        @Override
        boolean isConsumed(int index) {
            return this.consumed.get(index);
        }

        @Override
        public boolean isAllConsumed() {
            return this.remaining == 0;
        }

        @Override
        void setConsumed(int index) {
            this.consumed.set(index);
            --this.remaining;
        }
    }

    private final class ConsumerSmall
    extends Consumer {
        private long consumed;

        private ConsumerSmall() {
            this.consumed = PropertiesBag.this.propertiesMask ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        boolean isConsumed(int index) {
            return (this.consumed & 1L << index) != 0L;
        }

        @Override
        void setConsumed(int index) {
            this.consumed |= 1L << index;
        }

        @Override
        public boolean isAllConsumed() {
            return this.consumed == -1L;
        }
    }

    public static class Builder<T> {
        private final BeanIntrospection<T> beanIntrospection;
        private final int[] originalNameToPropertiesMapping;
        @Nullable
        private Map<String, Integer> nameToPropertiesMapping;
        private final List<DeserBean.DerProperty<T, Object>> mutableProperties;

        public Builder(BeanIntrospection<T> beanIntrospection) {
            this(beanIntrospection, beanIntrospection.getBeanProperties().size());
        }

        public Builder(BeanIntrospection<T> beanIntrospection, int expectedPropertiesSize) {
            this.beanIntrospection = beanIntrospection;
            int beanPropertiesSize = beanIntrospection.getBeanProperties().size();
            this.originalNameToPropertiesMapping = new int[beanPropertiesSize];
            Arrays.fill(this.originalNameToPropertiesMapping, -1);
            this.mutableProperties = new ArrayList<DeserBean.DerProperty<T, Object>>(expectedPropertiesSize);
        }

        public void register(String name, DeserBean.DerProperty<T, Object> derProperty, boolean addAliases) {
            int newPropertyIndex = this.mutableProperties.size();
            if (derProperty.beanProperty != null && derProperty.beanProperty.getDeclaringBean() == this.beanIntrospection && name.equals(derProperty.beanProperty.getName())) {
                this.originalNameToPropertiesMapping[this.beanIntrospection.propertyIndexOf((String)name)] = newPropertyIndex;
            } else {
                if (this.nameToPropertiesMapping == null) {
                    this.nameToPropertiesMapping = new HashMap<String, Integer>();
                }
                this.nameToPropertiesMapping.put(name, newPropertyIndex);
            }
            if (addAliases && derProperty.aliases != null && derProperty.aliases.length > 0) {
                if (this.nameToPropertiesMapping == null) {
                    this.nameToPropertiesMapping = new HashMap<String, Integer>();
                }
                for (String alias : derProperty.aliases) {
                    this.nameToPropertiesMapping.put(alias, newPropertyIndex);
                }
            }
            this.mutableProperties.add(derProperty);
        }

        @Nullable
        public PropertiesBag<T> build() {
            if (this.mutableProperties.isEmpty()) {
                return null;
            }
            return new PropertiesBag<T>(this.beanIntrospection, this.originalNameToPropertiesMapping, (DeserBean.DerProperty[])this.mutableProperties.toArray(DeserBean.DerProperty[]::new), this.nameToPropertiesMapping);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public abstract class Consumer {
        private Consumer() {
        }

        public boolean isNotConsumed(String name) {
            int propertyIndex = PropertiesBag.this.propertyIndexOf(name);
            return propertyIndex != -1 && !this.isConsumed(propertyIndex);
        }

        public DeserBean.DerProperty<T, Object> findNotConsumed(String name) {
            int propertyIndex = PropertiesBag.this.propertyIndexOf(name);
            if (propertyIndex == -1 || this.isConsumed(propertyIndex)) {
                return null;
            }
            return PropertiesBag.this.properties[propertyIndex];
        }

        public DeserBean.DerProperty<T, Object> consume(String name) {
            int propertyIndex = PropertiesBag.this.propertyIndexOf(name);
            if (propertyIndex == -1 || this.isConsumed(propertyIndex)) {
                return null;
            }
            this.setConsumed(propertyIndex);
            return PropertiesBag.this.properties[propertyIndex];
        }

        public DeserBean.DerProperty<T, Object> consume(int propertyIndex) {
            if (propertyIndex == -1 || this.isConsumed(propertyIndex)) {
                return null;
            }
            this.setConsumed(propertyIndex);
            return PropertiesBag.this.properties[propertyIndex];
        }

        public List<DeserBean.DerProperty<T, Object>> getNotConsumed() {
            ArrayList list = new ArrayList(PropertiesBag.this.properties.length);
            int bound = PropertiesBag.this.properties.length;
            for (int index = 0; index < bound; ++index) {
                if (this.isConsumed(index)) continue;
                list.add(PropertiesBag.this.properties[index]);
            }
            return list;
        }

        abstract boolean isConsumed(int var1);

        abstract void setConsumed(int var1);

        public abstract boolean isAllConsumed();
    }
}

