/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.support.deserializers.DemuxingObjectDecoder;
import io.micronaut.serde.support.deserializers.DeserBean;
import java.io.IOException;
import java.util.Map;

final class SubtypedPropertyObjectDeserializer
implements Deserializer<Object> {
    private final DeserBean<? super Object> deserBean;
    private final Map<String, Deserializer<Object>> deserializers;
    private final Deserializer<Object> supertypeDeserializer;
    private final boolean discriminatorVisible;

    public SubtypedPropertyObjectDeserializer(DeserBean<? super Object> deserBean, Map<String, Deserializer<Object>> deserializers, Deserializer<Object> supertypeDeserializer, boolean discriminatorVisible) {
        this.deserBean = deserBean;
        this.deserializers = deserializers;
        this.supertypeDeserializer = supertypeDeserializer;
        this.discriminatorVisible = discriminatorVisible;
        if (deserBean.subtypeInfo.discriminatorType() != SerdeConfig.SerSubtyped.DiscriminatorType.PROPERTY) {
            throw new IllegalStateException("Unsupported discriminator type: " + deserBean.subtypeInfo.discriminatorType());
        }
    }

    public Object deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super Object> type) throws IOException {
        try (DemuxingObjectDecoder.PrimedDecoder primed = DemuxingObjectDecoder.prime(decoder);){
            DemuxingObjectDecoder typeFinder = this.discriminatorVisible ? primed.decodeObjectNonConsuming(type) : primed.decodeObject(type);
            Deserializer<Object> deserializer = this.findDeserializer((Decoder)typeFinder);
            typeFinder.finishStructure(true);
            Object object = deserializer.deserialize((Decoder)primed, decoderContext, type);
            return object;
        }
    }

    @NonNull
    private Deserializer<Object> findDeserializer(Decoder objectDecoder) throws IOException {
        String key;
        String defaultImpl = this.deserBean.subtypeInfo.defaultImpl();
        String discriminatorName = this.deserBean.subtypeInfo.discriminatorName();
        while ((key = objectDecoder.decodeKey()) != null) {
            if (key.equals(discriminatorName)) {
                String subtypeName;
                Deserializer<Object> deserializer;
                if (objectDecoder.decodeNull() || (deserializer = this.deserializers.get(subtypeName = objectDecoder.decodeString())) == null) break;
                return deserializer;
            }
            objectDecoder.skipValue();
        }
        if (defaultImpl != null) {
            return this.deserializers.get(defaultImpl);
        }
        return this.supertypeDeserializer;
    }
}

