/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.InetAddress;

@Singleton
public class InetAddressSerde
implements Serde<InetAddress> {
    private final boolean asNumeric;

    public InetAddressSerde(SerdeConfiguration serdeConfiguration) {
        this.asNumeric = serdeConfiguration.isInetAddressAsNumeric();
    }

    @Nullable
    public InetAddress deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super InetAddress> type) throws IOException {
        return InetAddress.getByName(decoder.decodeString());
    }

    public void serialize(@NonNull Encoder encoder, @NonNull Serializer.EncoderContext context, @NonNull Argument<? extends InetAddress> type, @NonNull InetAddress value) throws IOException {
        String str;
        if (this.asNumeric) {
            str = value.getHostAddress();
        } else {
            str = value.toString().trim();
            int ix = str.indexOf(47);
            if (ix >= 0) {
                str = ix == 0 ? str.substring(1) : str.substring(0, ix);
            }
        }
        encoder.encodeString(str);
    }
}

