/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.serde.Encoder;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.DefaultFormattedTemporalSerde;
import io.micronaut.serde.support.serdes.TemporalSerde;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;

@Singleton
public final class LocalDateSerde
extends DefaultFormattedTemporalSerde<LocalDate>
implements TemporalSerde<LocalDate> {
    private final boolean writeNumeric;

    LocalDateSerde(SerdeConfiguration configuration) {
        super(configuration, DateTimeFormatter.ISO_LOCAL_DATE);
        this.writeNumeric = configuration.getTimeWriteShape() != SerdeConfiguration.TimeShape.STRING;
    }

    @Override
    public TemporalQuery<LocalDate> query() {
        return TemporalQueries.localDate();
    }

    @Override
    void serialize0(Encoder encoder, LocalDate value) throws IOException {
        if (this.writeNumeric) {
            encoder.encodeLong(value.toEpochDay());
        } else {
            super.serialize0(encoder, value);
        }
    }

    @Override
    LocalDate deserializeFallback(DateTimeException exc, String s) {
        long l;
        try {
            l = Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            exc.addSuppressed(e);
            throw exc;
        }
        return LocalDate.ofEpochDay(l);
    }
}

