/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.GenericPlaceholder;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.serializers.CustomizedObjectSerializer;
import io.micronaut.serde.support.serializers.JsonValueSerializer;
import io.micronaut.serde.support.serializers.RuntimeTypeSerializer;
import io.micronaut.serde.support.serializers.SerBean;
import io.micronaut.serde.support.serializers.SerBeanKey;
import io.micronaut.serde.support.serializers.SimpleObjectSerializer;
import io.micronaut.serde.support.serializers.WrappedObjectSerializer;
import io.micronaut.serde.support.util.SerdeArgumentConf;
import io.micronaut.serde.util.CustomizableSerializer;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@Internal
@Singleton
@Primary
@BootstrapContextCompatible
public final class ObjectSerializer
implements CustomizableSerializer<Object> {
    private final SerdeIntrospections introspections;
    private final SerializationConfiguration configuration;
    private final BeanContext beanContext;
    private final Map<SerBeanKey, Supplier<SerBean<?>>> serBeanMap = new ConcurrentHashMap(50);

    public ObjectSerializer(SerdeIntrospections introspections, SerializationConfiguration configuration, BeanContext beanContext) {
        this.introspections = introspections;
        this.configuration = configuration;
        this.beanContext = beanContext;
    }

    public io.micronaut.serde.ObjectSerializer<Object> createSpecific(@NonNull Serializer.EncoderContext encoderContext, Argument<?> type) throws SerdeException {
        boolean isObjectType = type.equalsType(Argument.OBJECT_ARGUMENT);
        if (isObjectType || type instanceof GenericPlaceholder) {
            io.micronaut.serde.ObjectSerializer<Object> outer = !isObjectType ? this.createSpecificInternal(encoderContext, type) : null;
            return new RuntimeTypeSerializer(encoderContext, (Serializer<Object>)outer, type);
        }
        return this.createSpecificInternal(encoderContext, type);
    }

    private io.micronaut.serde.ObjectSerializer<Object> createSpecificInternal(Serializer.EncoderContext encoderContext, Argument<?> type) throws SerdeException {
        SerBean<?> serBean;
        try {
            serBean = this.getSerializableBean(type, encoderContext);
        }
        catch (IntrospectionException e) {
            return new RuntimeTypeSerializer(encoderContext, e, type);
        }
        Object serializer = serBean.simpleBean ? new SimpleObjectSerializer(serBean) : (serBean.jsonValue != null ? new JsonValueSerializer(serBean.jsonValue) : new CustomizedObjectSerializer(serBean));
        if (serBean.subtyped) {
            serializer = new RuntimeTypeSerializer(encoderContext, (Serializer<Object>)serializer, type);
        }
        if (serBean.wrapperProperty != null) {
            serializer = new WrappedObjectSerializer<Object>((Serializer<Object>)serializer, serBean.wrapperProperty);
        }
        return serializer;
    }

    private <T> SerBean<T> getSerializableBean(Argument<T> type, Serializer.EncoderContext context) throws SerdeException {
        AnnotationMetadata annotationMetadata = type.getAnnotationMetadata();
        SerdeArgumentConf serdeArgumentConf = annotationMetadata.isEmpty() ? null : new SerdeArgumentConf(annotationMetadata);
        SerBeanKey key = new SerBeanKey(type, serdeArgumentConf);
        Supplier serBeanSupplier = this.serBeanMap.computeIfAbsent(key, ignore -> SupplierUtil.memoizedNonEmpty(() -> {
            try {
                return new SerBean(type, this.introspections, context, this.configuration, serdeArgumentConf, this.beanContext);
            }
            catch (SerdeException e) {
                throw new IntrospectionException("Error creating deserializer for type [" + type + "]: " + e.getMessage(), (Throwable)e);
            }
        }));
        SerBean serBean = (SerBean)serBeanSupplier.get();
        serBean.initialize(context);
        return serBean;
    }
}

