/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Internal
final class RuntimeTypeSerializer
implements ObjectSerializer<Object> {
    private final Serializer.EncoderContext encoderContext;
    private final Map<Class<?>, Serializer<Object>> inners = new ConcurrentHashMap(10);
    @Nullable
    private final Serializer<Object> outer;
    @Nullable
    private final IntrospectionException introspectionException;
    private final Argument<?> outerType;

    public RuntimeTypeSerializer(Serializer.EncoderContext encoderContext, @Nullable Serializer<Object> outer, @Nullable IntrospectionException introspectionException, Argument<?> outerType) {
        this.encoderContext = encoderContext;
        this.outer = outer;
        this.introspectionException = introspectionException;
        this.outerType = outerType;
    }

    public RuntimeTypeSerializer(Serializer.EncoderContext encoderContext, Serializer<Object> outer, Argument<?> type) {
        this(encoderContext, outer, null, type);
    }

    public RuntimeTypeSerializer(Serializer.EncoderContext encoderContext, IntrospectionException introspectionException, Argument<?> type) {
        this(encoderContext, null, introspectionException, type);
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<?> type, Object value) throws IOException {
        if (value == null) {
            encoder.encodeNull();
        } else {
            Serializer<Object> serializer;
            Class<?> t = value.getClass();
            if (this.outer != null && t == type.getType()) {
                serializer = this.outer;
            } else {
                type = Argument.of(t);
                serializer = this.getSerializer(context, value);
            }
            serializer.serialize(encoder, context, type, value);
        }
    }

    public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<?> type, Object value) throws IOException {
        Serializer<Object> serializer;
        Class<?> t = value.getClass();
        if (this.outer != null && t == type.getType()) {
            serializer = this.outer;
        } else {
            type = Argument.of(t);
            serializer = this.getSerializer(context, value);
        }
        if (!(serializer instanceof ObjectSerializer)) {
            throw this.serializeIntoNotSupported(type);
        }
        ObjectSerializer objectSerializer = (ObjectSerializer)serializer;
        objectSerializer.serializeInto(encoder, context, type, value);
    }

    private SerdeException serializeIntoNotSupported(Argument<?> type) {
        return new SerdeException("Serializer for type: " + type + " doesn't support serializing into an existing object");
    }

    public boolean isEmpty(Serializer.EncoderContext context, Object value) {
        if (value == null) {
            return true;
        }
        try {
            return this.getSerializer(context, value).isEmpty(context, value);
        }
        catch (SerdeException serdeException) {
            return super.isEmpty(context, value);
        }
    }

    public boolean isAbsent(Serializer.EncoderContext context, Object value) {
        if (value == null) {
            return true;
        }
        try {
            return this.getSerializer(context, value).isAbsent(context, value);
        }
        catch (SerdeException serdeException) {
            return super.isAbsent(context, value);
        }
    }

    private Serializer<Object> getSerializer(Serializer.EncoderContext context, Object value) throws SerdeException {
        try {
            return this.inners.computeIfAbsent(value.getClass(), t -> {
                try {
                    if (value.getClass().equals(this.outerType.getType())) {
                        if (this.outer == null) {
                            throw new SerdeException(this.introspectionException.getMessage(), (Throwable)this.introspectionException);
                        }
                        return this.outer;
                    }
                    Argument arg = Argument.of(value.getClass());
                    return this.encoderContext.findSerializer(arg).createSpecific(context, arg);
                }
                catch (SerdeException ex) {
                    throw new IntrospectionException("No serializer found for type: " + value.getClass(), (Throwable)ex);
                }
            });
        }
        catch (IntrospectionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof SerdeException) {
                SerdeException serdeException = (SerdeException)throwable;
                throw serdeException;
            }
            throw e;
        }
    }
}

