/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.UnsafeBeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.PropertyFilter;
import io.micronaut.serde.SerdeIntrospections;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.config.naming.PropertyNamingStrategy;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.util.SerdeAnnotationUtil;
import io.micronaut.serde.support.util.SerdeArgumentConf;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.LoggerFactory;

@Internal
final class SerBean<T> {
    private static final Comparator<BeanProperty<?, Object>> BEAN_PROPERTY_COMPARATOR = (o1, o2) -> OrderUtil.COMPARATOR.compare(new Ordered((BeanProperty)o1){
        final /* synthetic */ BeanProperty val$o1;
        {
            this.val$o1 = beanProperty;
        }

        public int getOrder() {
            return this.val$o1.intValue(Order.class).orElse(0);
        }
    }, new Ordered((BeanProperty)o2){
        final /* synthetic */ BeanProperty val$o2;
        {
            this.val$o2 = beanProperty;
        }

        public int getOrder() {
            return this.val$o2.intValue(Order.class).orElse(0);
        }
    });
    private static final String JK_PROP = "com.fasterxml.jackson.annotation.JsonProperty";
    private static final String JACKSON_VALUE = "com.fasterxml.jackson.annotation.JsonValue";
    @NonNull
    public final BeanIntrospection<T> introspection;
    public final List<SerProperty<T, Object>> writeProperties;
    @Nullable
    public final String wrapperProperty;
    @Nullable
    public SerProperty<T, Object> jsonValue;
    public final SerializationConfiguration configuration;
    public final boolean simpleBean;
    public final boolean subtyped;
    public final PropertyFilter propertyFilter;
    @Nullable
    private final SerdeArgumentConf serdeArgumentConf;
    private volatile boolean initialized;
    private volatile boolean initializing;
    private List<Initializer> initializers = new ArrayList<Initializer>();

    SerBean(Argument<T> type, SerdeIntrospections introspections, Serializer.EncoderContext encoderContext, SerializationConfiguration configuration, @Nullable SerdeArgumentConf serdeArgumentConf, BeanContext beanContext) throws SerdeException {
        this.serdeArgumentConf = serdeArgumentConf;
        this.configuration = configuration;
        this.introspection = introspections.getSerializableIntrospection(type);
        this.propertyFilter = this.getPropertyFilterIfPresent(beanContext, type.getSimpleName());
        boolean allowIgnoredProperties = this.introspection.booleanValue(SerdeConfig.SerIgnored.class, "allowSerialize").orElse(false);
        @Nullable Predicate<String> argumentPropertyPredicate = serdeArgumentConf == null ? null : serdeArgumentConf.resolveAllowPropertyPredicate(allowIgnoredProperties);
        PropertyNamingStrategy entityPropertyNamingStrategy = this.getPropertyNamingStrategy((AnnotationMetadata)this.introspection, encoderContext, null);
        List<Map.Entry> properties = this.introspection.getBeanProperties().stream().filter(this::filterProperty).sorted(this.getPropertyComparator()).map(beanProperty -> {
            Optional<Argument> constructorArgument = Arrays.stream(this.introspection.getConstructor().getArguments()).filter(a -> a.getName().equals(beanProperty.getName()) && a.getType().equals(beanProperty.getType())).findFirst();
            return constructorArgument.map(argument -> new AbstractMap.SimpleEntry<BeanProperty, AnnotationMetadataHierarchy>((BeanProperty)beanProperty, new AnnotationMetadataHierarchy(new AnnotationMetadata[]{argument.getAnnotationMetadata(), beanProperty.getAnnotationMetadata()}))).orElseGet(() -> new AbstractMap.SimpleEntry<BeanProperty, AnnotationMetadata>((BeanProperty)beanProperty, beanProperty.getAnnotationMetadata()));
        }).toList();
        Map.Entry serPropEntry = properties.stream().filter(bp -> ((AnnotationMetadata)bp.getValue()).hasAnnotation(SerdeConfig.SerValue.class) || ((AnnotationMetadata)bp.getValue()).hasAnnotation(JACKSON_VALUE)).findFirst().orElse(null);
        if (serPropEntry != null) {
            this.wrapperProperty = null;
            BeanProperty beanProperty2 = (BeanProperty)serPropEntry.getKey();
            Argument serType = beanProperty2.asArgument();
            AnnotationMetadata propertyAnnotationMetadata = (AnnotationMetadata)serPropEntry.getValue();
            this.jsonValue = new PropSerProperty<T, Object>(this, beanProperty2.getName(), beanProperty2.getName(), serType, propertyAnnotationMetadata, beanProperty2);
            this.initializers.add(ctx -> this.initProperty(this.jsonValue, ctx));
            this.writeProperties = Collections.emptyList();
        } else {
            BeanMethod serMethod = this.introspection.getBeanMethods().stream().filter(m -> m.isAnnotationPresent(SerdeConfig.SerValue.class) || m.getAnnotationMetadata().hasAnnotation(JACKSON_VALUE)).findFirst().orElse(null);
            if (serMethod != null) {
                this.wrapperProperty = null;
                this.jsonValue = new MethodSerProperty<T, Object>(this, serMethod.getName(), serMethod.getName(), serMethod.getReturnType().asArgument(), serMethod.getAnnotationMetadata(), serMethod);
                this.initializers.add(ctx -> this.initProperty(this.jsonValue, ctx));
                this.writeProperties = Collections.emptyList();
            } else {
                AnnotationMetadataHierarchy annotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.introspection, type.getAnnotationMetadata()});
                ArrayList<BeanMethod> jsonGetters = new ArrayList<BeanMethod>(this.introspection.getBeanMethods().size());
                for (BeanMethod beanMethod : this.introspection.getBeanMethods()) {
                    if (!beanMethod.isAnnotationPresent(SerdeConfig.SerGetter.class) && !beanMethod.isAnnotationPresent(SerdeConfig.SerAnyGetter.class)) continue;
                    jsonGetters.add(beanMethod);
                }
                Optional subType = annotationMetadata.stringValue(SerdeConfig.class, "typeName");
                HashSet addedProperties = CollectionUtils.newHashSet((int)properties.size());
                if (!properties.isEmpty() || !jsonGetters.isEmpty() || subType.isPresent()) {
                    this.writeProperties = new ArrayList<SerProperty<T, Object>>(properties.size() + jsonGetters.size());
                    subType.ifPresent(arg_0 -> this.lambda$new$11((AnnotationMetadata)annotationMetadata, arg_0));
                    for (Map.Entry propWithAnnotations : properties) {
                        BeanProperty property = (BeanProperty)propWithAnnotations.getKey();
                        Argument argument = property.asArgument();
                        AnnotationMetadata propertyAnnotationMetadata = (AnnotationMetadata)propWithAnnotations.getValue();
                        PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(property.getAnnotationMetadata(), encoderContext, entityPropertyNamingStrategy);
                        String originalName = argument.getName();
                        String resolvedPropertyName = this.resolveName(propertyAnnotationMetadata, originalName, serdeArgumentConf, propertyNamingStrategy);
                        if (argumentPropertyPredicate != null && !argumentPropertyPredicate.test(resolvedPropertyName)) continue;
                        addedProperties.add(resolvedPropertyName);
                        PropSerProperty serProperty = new PropSerProperty(this, resolvedPropertyName, originalName, argument, propertyAnnotationMetadata, property);
                        this.initializers.add(ctx -> {
                            try {
                                this.initProperty(serProperty, ctx);
                            }
                            catch (SerdeException e) {
                                throw new SerdeException("Error resolving serializer for property [" + property + "] of type [" + argument.getType().getName() + "]: " + e.getMessage(), (Throwable)e);
                            }
                        });
                        this.writeProperties.add(serProperty);
                    }
                    for (BeanMethod jsonGetter : jsonGetters) {
                        PropertyNamingStrategy propertyNamingStrategy = this.getPropertyNamingStrategy(jsonGetter.getAnnotationMetadata(), encoderContext, entityPropertyNamingStrategy);
                        AnnotationMetadata jsonGetterAnnotationMetadata = jsonGetter.getAnnotationMetadata();
                        String originalName = NameUtils.getPropertyNameForGetter((String)jsonGetter.getName());
                        String resolvedPropertyName = this.resolveName(jsonGetterAnnotationMetadata, originalName, serdeArgumentConf, propertyNamingStrategy);
                        if (argumentPropertyPredicate != null && !argumentPropertyPredicate.test(resolvedPropertyName) || !addedProperties.add(resolvedPropertyName)) continue;
                        Argument returnType = jsonGetter.getReturnType().asArgument();
                        MethodSerProperty prop = new MethodSerProperty(this, resolvedPropertyName, originalName, returnType, jsonGetterAnnotationMetadata, jsonGetter);
                        this.writeProperties.add(prop);
                        this.initializers.add(ctx -> this.initProperty(prop, ctx));
                    }
                } else {
                    this.writeProperties = new ArrayList<SerProperty<T, Object>>();
                }
                this.wrapperProperty = this.introspection.stringValue(SerdeConfig.class, "wrapperProperty").orElse(null);
            }
        }
        if (!this.writeProperties.isEmpty() && serdeArgumentConf != null && serdeArgumentConf.order() != null) {
            List<String> order = Arrays.asList(serdeArgumentConf.order());
            this.writeProperties.sort(Comparator.comparingInt(o -> {
                int index = order.indexOf(o.name);
                if (index == -1) {
                    return order.indexOf(o.originalName);
                }
                return index;
            }));
        }
        this.simpleBean = this.isSimpleBean();
        boolean isAbstractIntrospection = Modifier.isAbstract(this.introspection.getBeanType().getModifiers());
        this.subtyped = isAbstractIntrospection || this.introspection.getAnnotationMetadata().hasDeclaredAnnotation(SerdeConfig.SerSubtyped.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Serializer.EncoderContext encoderContext) throws SerdeException {
        if (!this.initialized) {
            SerBean serBean = this;
            synchronized (serBean) {
                if (!this.initialized && !this.initializing) {
                    this.initializing = true;
                    for (Initializer initializer : this.initializers) {
                        initializer.initialize(encoderContext);
                    }
                    this.initializers = null;
                    this.initialized = true;
                    this.initializing = false;
                }
            }
        }
    }

    private <Y, Z> void initProperty(SerProperty<Y, Z> prop, Serializer.EncoderContext encoderContext) throws SerdeException {
        if (prop.serializer != null) {
            return;
        }
        Class customSer = prop.annotationMetadata.classValue(SerdeConfig.class, "serializerClass").orElse(null);
        Argument argument = prop.argument;
        if (this.serdeArgumentConf != null) {
            argument = this.serdeArgumentConf.extendArgumentWithPrefixSuffix(argument);
        }
        Serializer serializer = customSer != null ? encoderContext.findCustomSerializer(customSer) : encoderContext.findSerializer(argument);
        prop.serializer = serializer.createSpecific(encoderContext, argument);
        if (prop.serializableInto) {
            Serializer serializer2 = prop.serializer;
            if (serializer2 instanceof ObjectSerializer) {
                ObjectSerializer objectSerializer;
                prop.objectSerializer = objectSerializer = (ObjectSerializer)serializer2;
            } else {
                throw new SerdeException("Serializer for a property: " + prop.name + " doesn't support serializing into an existing object");
            }
        }
        prop.annotationMetadata = null;
    }

    private boolean isSimpleBean() {
        if (this.propertyFilter != null || this.jsonValue != null) {
            return false;
        }
        for (SerProperty<T, Object> property : this.writeProperties) {
            if (!property.serializableInto && property.backRef == null && property.include == SerdeConfig.SerInclude.ALWAYS && property.views == null && property.managedRef == null) continue;
            return false;
        }
        return true;
    }

    private PropertyNamingStrategy getPropertyNamingStrategy(AnnotationMetadata annotationMetadata, Serializer.EncoderContext encoderContext, PropertyNamingStrategy defaultNamingStrategy) throws SerdeException {
        Class namingStrategyClass = annotationMetadata.classValue(SerdeConfig.class, "runtimeNaming").orElse(null);
        return namingStrategyClass == null ? defaultNamingStrategy : encoderContext.findNamingStrategy(namingStrategyClass);
    }

    private Comparator<BeanProperty<?, Object>> getPropertyComparator() {
        return BEAN_PROPERTY_COMPARATOR;
    }

    private String resolveName(final AnnotationMetadata propertyAnnotationMetadata, final String name, @Nullable SerdeArgumentConf serdeArgumentConf, PropertyNamingStrategy propertyNamingStrategy) {
        String resolvedName;
        String string = resolvedName = propertyNamingStrategy == null ? (String)propertyAnnotationMetadata.stringValue(SerdeConfig.class, "property").orElse(null) : propertyNamingStrategy.translate(new AnnotatedElement(){

            public String getName() {
                return name;
            }

            public AnnotationMetadata getAnnotationMetadata() {
                return propertyAnnotationMetadata;
            }
        });
        if (resolvedName == null) {
            resolvedName = propertyAnnotationMetadata.stringValue(JK_PROP).orElse(name);
        }
        if (serdeArgumentConf != null) {
            return serdeArgumentConf.applyPrefixSuffix(resolvedName);
        }
        return resolvedName;
    }

    private PropertyFilter getPropertyFilterIfPresent(BeanContext beanContext, String typeName) {
        Optional filterName = this.introspection.stringValue(SerdeConfig.class, "filter");
        if (filterName.isPresent() && !((String)filterName.get()).isEmpty()) {
            return beanContext.findBean(PropertyFilter.class, Qualifiers.byName((String)((String)filterName.get()))).orElseGet(() -> {
                LoggerFactory.getLogger(SerBean.class).warn("Json filter with name '{}' was defined on type {} but no PropertyFilter bean with the name exists", filterName.get(), (Object)typeName);
                return null;
            });
        }
        return null;
    }

    private boolean filterProperty(BeanProperty<T, Object> property) {
        return !property.isWriteOnly() && property.booleanValue(SerdeConfig.class, "ignored").orElse(false) == false && property.booleanValue(SerdeConfig.class, "ignoredSerialization").orElse(false) == false && property.booleanValue(SerdeConfig.class, "readOnly").orElse(false) == false;
    }

    private /* synthetic */ void lambda$new$11(AnnotationMetadata annotationMetadata, String typeName) {
        String typeProperty = annotationMetadata.stringValue(SerdeConfig.class, "typeProperty").orElse(null);
        if (typeProperty != null) {
            SerProperty prop = "$CLASS_SIMPLE_NAME".equals(typeName) ? new CustomSerProperty<Object, String>(this, typeProperty, Argument.of(String.class, (String)typeProperty), t -> t.getClass().getSimpleName()) : new InjectedSerProperty(this, typeProperty, Argument.of(String.class, (String)typeProperty), typeName);
            this.writeProperties.add(prop);
            this.initializers.add(context -> {
                try {
                    this.initProperty(prop, context);
                }
                catch (SerdeException e) {
                    throw new IntrospectionException("Error configuring subtype binding for type " + this.introspection.getBeanType() + ": " + e.getMessage());
                }
            });
        }
    }

    static final class PropSerProperty<B, P>
    extends SerProperty<B, P> {
        private final UnsafeBeanProperty<B, P> beanProperty;

        public PropSerProperty(SerBean<B> bean, String name, String originalName, Argument<P> argument, AnnotationMetadata annotationMetadata, BeanProperty<B, P> beanProperty) {
            super(bean, name, originalName, argument, annotationMetadata);
            this.beanProperty = (UnsafeBeanProperty)beanProperty;
        }

        @Override
        public P get(B bean) {
            return (P)this.beanProperty.getUnsafe(bean);
        }
    }

    @Internal
    static abstract class SerProperty<B, P> {
        public final String name;
        public final String originalName;
        public final Argument<P> argument;
        public final Class<?>[] views;
        public final String managedRef;
        public final String backRef;
        public final SerdeConfig.SerInclude include;
        public final boolean serializableInto;
        public Serializer<P> serializer;
        @Nullable
        public ObjectSerializer<P> objectSerializer;
        public AnnotationMetadata annotationMetadata;

        public SerProperty(SerBean<B> bean, @NonNull String name, @NonNull String originalName, @NonNull Argument<P> argument) {
            this(bean, name, originalName, argument, argument.getAnnotationMetadata());
        }

        public SerProperty(SerBean<B> bean, @NonNull String name, @NonNull String originalName, @NonNull Argument<P> argument, @NonNull AnnotationMetadata annotationMetadata) {
            this.name = name;
            this.originalName = originalName;
            this.argument = argument;
            AnnotationMetadata beanMetadata = bean.introspection.getAnnotationMetadata();
            AnnotationMetadata hierarchy = annotationMetadata.isEmpty() ? beanMetadata : new AnnotationMetadataHierarchy(new AnnotationMetadata[]{beanMetadata, annotationMetadata});
            this.views = SerdeAnnotationUtil.resolveViews(beanMetadata, annotationMetadata);
            this.include = hierarchy.enumValue(SerdeConfig.class, "include", SerdeConfig.SerInclude.class).orElse(bean.configuration.getInclusion());
            this.managedRef = annotationMetadata.stringValue(SerdeConfig.SerManagedRef.class).orElse(null);
            this.backRef = annotationMetadata.stringValue(SerdeConfig.SerBackRef.class).orElse(null);
            this.annotationMetadata = annotationMetadata;
            this.serializableInto = annotationMetadata.hasAnnotation(SerdeConfig.SerUnwrapped.class) || annotationMetadata.hasAnnotation(SerdeConfig.SerAnyGetter.class);
        }

        public abstract P get(B var1);
    }

    private static interface Initializer {
        public void initialize(Serializer.EncoderContext var1) throws SerdeException;
    }

    static final class MethodSerProperty<B, P>
    extends SerProperty<B, P> {
        private final BeanMethod<B, P> beanMethod;

        public MethodSerProperty(SerBean<B> bean, String name, String originalName, Argument<P> argument, AnnotationMetadata annotationMetadata, BeanMethod<B, P> beanMethod) {
            super(bean, name, originalName, argument, annotationMetadata);
            this.beanMethod = beanMethod;
        }

        @Override
        public P get(B bean) {
            return (P)this.beanMethod.invoke(bean, new Object[0]);
        }
    }

    static final class CustomSerProperty<B, P>
    extends SerProperty<B, P> {
        private final Function<B, P> reader;

        public CustomSerProperty(SerBean<B> bean, String name, Argument<P> argument, Function<B, P> reader) {
            super(bean, name, name, argument);
            this.reader = reader;
        }

        @Override
        public P get(B bean) {
            return this.reader.apply(bean);
        }
    }

    static final class InjectedSerProperty<B, P>
    extends SerProperty<B, P> {
        private final P injected;

        public InjectedSerProperty(SerBean<B> bean, String name, Argument<P> argument, P injected) {
            super(bean, name, name, argument);
            this.injected = injected;
        }

        @Override
        public P get(B bean) {
            return this.injected;
        }
    }
}

