/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import java.io.IOException;

@Internal
final class WrappedObjectSerializer<T>
implements ObjectSerializer<T> {
    private final Serializer<T> serializer;
    private final String wrapperProperty;

    WrappedObjectSerializer(Serializer<T> serializer, String wrapperProperty) {
        this.serializer = serializer;
        this.wrapperProperty = wrapperProperty;
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        try (Encoder wrapperEncoder = encoder.encodeObject(Argument.OBJECT_ARGUMENT);){
            wrapperEncoder.encodeKey(this.wrapperProperty);
            this.serializer.serialize(encoder, context, type, value);
        }
    }

    public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends T> type, T value) throws IOException {
        encoder.encodeKey(this.wrapperProperty);
        this.serializer.serialize(encoder, context, type, value);
    }
}

