/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.DefaultFormattedTemporalSerde;
import io.micronaut.serde.support.serdes.NumericSupportTemporalSerde;
import io.micronaut.serde.support.serdes.TemporalSerde;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;

@Singleton
public final class OffsetDateTimeSerde
extends NumericSupportTemporalSerde<OffsetDateTime> {
    OffsetDateTimeSerde(SerdeConfiguration configuration) {
        super(configuration, DateTimeFormatter.ISO_OFFSET_DATE_TIME, SerdeConfiguration.NumericTimeUnit.MILLISECONDS);
    }

    @Override
    public TemporalQuery<OffsetDateTime> query() {
        return OffsetDateTime::from;
    }

    @Override
    protected OffsetDateTime fromNanos(long seconds, int nanos) {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(seconds, nanos), TemporalSerde.UTC);
    }

    @Override
    protected long getSecondPart(OffsetDateTime value) {
        return value.toInstant().getEpochSecond();
    }

    @Override
    protected int getNanoPart(OffsetDateTime value) {
        return value.toInstant().getNano();
    }

    @Override
    protected DefaultFormattedTemporalSerde<OffsetDateTime> createSpecific(SerdeConfiguration configuration) {
        return new OffsetDateTimeSerde(configuration);
    }
}

