/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.support.serdes.DefaultFormattedTemporalSerde;
import io.micronaut.serde.support.serdes.NumericSupportTemporalSerde;
import io.micronaut.serde.support.serdes.TemporalSerde;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;

@Singleton
public final class ZonedDateTimeSerde
extends NumericSupportTemporalSerde<ZonedDateTime>
implements TemporalSerde<ZonedDateTime> {
    ZonedDateTimeSerde(SerdeConfiguration configuration) {
        super(configuration, DateTimeFormatter.ISO_ZONED_DATE_TIME, SerdeConfiguration.NumericTimeUnit.MILLISECONDS);
    }

    @Override
    public TemporalQuery<ZonedDateTime> query() {
        return ZonedDateTime::from;
    }

    @Override
    protected ZonedDateTime fromNanos(long seconds, int nanos) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(seconds, nanos), UTC);
    }

    @Override
    protected long getSecondPart(ZonedDateTime value) {
        return value.toInstant().getEpochSecond();
    }

    @Override
    protected int getNanoPart(ZonedDateTime value) {
        return value.toInstant().getNano();
    }

    @Override
    protected DefaultFormattedTemporalSerde<ZonedDateTime> createSpecific(SerdeConfiguration configuration) {
        return new ZonedDateTimeSerde(configuration);
    }
}

