/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.SerializationConfiguration;
import io.micronaut.serde.support.util.SerdeArgumentConf;
import java.util.Objects;

@Internal
final class SerBeanKey {
    private final SerdeConfiguration serdeConfiguration;
    private final SerializationConfiguration serializationConfiguration;
    private final Argument<?> type;
    @Nullable
    private final SerdeArgumentConf serdeArgumentConf;
    private final int hashCode;

    public SerBeanKey(SerdeConfiguration serdeConfiguration, SerializationConfiguration serializationConfiguration, @NonNull Argument<?> type, @Nullable SerdeArgumentConf serdeArgumentConf) {
        this.serdeConfiguration = serdeConfiguration;
        this.serializationConfiguration = serializationConfiguration;
        this.type = type;
        this.serdeArgumentConf = serdeArgumentConf;
        this.hashCode = type.typeHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerBeanKey that = (SerBeanKey)o;
        return this.type.equalsType(that.type) && Objects.equals(this.serdeArgumentConf, that.serdeArgumentConf) && this.serializationConfiguration == that.serializationConfiguration && this.serdeConfiguration == that.serdeConfiguration;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @NonNull
    public Argument<?> getType() {
        return this.type;
    }
}

