/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.ByteBuffer;

@Singleton
public class ByteBufferSerde
implements Serde<ByteBuffer> {
    @Nullable
    public ByteBuffer deserialize(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super ByteBuffer> type) throws IOException {
        byte[] b = decoder.decodeBinary();
        return ByteBuffer.wrap(b);
    }

    public void serialize(@NonNull Encoder encoder, @NonNull Serializer.EncoderContext context, @NonNull Argument<? extends ByteBuffer> type, @NonNull ByteBuffer value) throws IOException {
        ByteBuffer slice = value.asReadOnlyBuffer();
        ByteBuffer copy = ByteBuffer.allocate(slice.remaining());
        copy.put(slice);
        encoder.encodeBinary(copy.array());
    }
}

