/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.util.CustomizableSerializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

@Singleton
class OptionalValuesSerializer<V>
implements CustomizableSerializer<OptionalValues<V>> {
    OptionalValuesSerializer() {
    }

    public ObjectSerializer<OptionalValues<V>> createSpecific(Serializer.EncoderContext context, Argument<? extends OptionalValues<V>> type) throws SerdeException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty((Object[])generics)) {
            throw new SerdeException("Cannot serialize raw OptionalValues");
        }
        Object generic = generics[0];
        final Serializer valueSerializer = context.findSerializer((Argument)generic).createSpecific(context, (Argument)generic);
        return new ObjectSerializer<OptionalValues<V>>((Argument)generic){
            final /* synthetic */ Argument val$generic;
            {
                this.val$generic = argument;
            }

            public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends OptionalValues<V>> type, OptionalValues<V> value) throws IOException {
                for (CharSequence key : value) {
                    Optional opt = value.get(key);
                    if (!opt.isPresent()) continue;
                    encoder.encodeKey(key.toString());
                    valueSerializer.serialize(encoder, context, this.val$generic, opt.get());
                }
            }

            public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends OptionalValues<V>> type, OptionalValues<V> value) throws IOException {
                Objects.requireNonNull(value, "Value cannot be null");
                Encoder objectEncoder = encoder.encodeObject(type);
                this.serializeInto(encoder, context, type, value);
                objectEncoder.finishStructure();
            }
        };
    }

    public boolean isEmpty(Serializer.EncoderContext context, OptionalValues<V> value) {
        return value.isEmpty();
    }
}

