/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.json.tree.JsonNode;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.exceptions.InvalidFormatException;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.util.JsonArrayNodeDecoder;
import io.micronaut.serde.support.util.JsonObjectNodeDecoder;
import io.micronaut.serde.util.BinaryCodecUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public abstract class JsonNodeDecoder
extends LimitingStream
implements Decoder {
    JsonNodeDecoder(LimitingStream.RemainingLimits remainingLimits) {
        super(remainingLimits);
    }

    public static JsonNodeDecoder create(JsonNode node, LimitingStream.RemainingLimits remainingLimits) {
        return new Buffered(node, remainingLimits);
    }

    protected abstract JsonNode peekValue() throws IOException;

    public Decoder decodeArray(Argument<?> type) throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isArray()) {
            this.skipValue();
            return new JsonArrayNodeDecoder(peeked, this.childLimits());
        }
        throw this.createDeserializationException("Not an array", JsonNodeDecoder.toArbitrary(peeked));
    }

    public Decoder decodeObject(Argument<?> type) throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isObject()) {
            this.skipValue();
            return new JsonObjectNodeDecoder(peeked, this.childLimits());
        }
        throw this.createDeserializationException("Not an array", JsonNodeDecoder.toArbitrary(peeked));
    }

    public String decodeString() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isString()) {
            this.skipValue();
            return peeked.getStringValue();
        }
        throw this.createDeserializationException("Not a string", JsonNodeDecoder.toArbitrary(peeked));
    }

    public boolean decodeBoolean() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isBoolean()) {
            this.skipValue();
            return peeked.getBooleanValue();
        }
        throw this.createDeserializationException("Not a boolean", JsonNodeDecoder.toArbitrary(peeked));
    }

    public byte decodeByte() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return (byte)peeked.getIntValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public short decodeShort() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return (short)peeked.getIntValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public char decodeChar() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return (char)peeked.getIntValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public int decodeInt() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getIntValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public long decodeLong() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getLongValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public float decodeFloat() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getFloatValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public double decodeDouble() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getDoubleValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public BigInteger decodeBigInteger() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getBigIntegerValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public BigDecimal decodeBigDecimal() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNumber()) {
            this.skipValue();
            return peeked.getBigDecimalValue();
        }
        throw this.createDeserializationException("Not a number", JsonNodeDecoder.toArbitrary(peeked));
    }

    public byte @NonNull [] decodeBinary() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isString()) {
            return BinaryCodecUtil.decodeFromBase64String((Decoder)this);
        }
        return BinaryCodecUtil.decodeFromArray((Decoder)this);
    }

    public boolean decodeNull() throws IOException {
        JsonNode peeked = this.peekValue();
        if (peeked.isNull()) {
            this.skipValue();
            return true;
        }
        return false;
    }

    public Object decodeArbitrary() throws IOException {
        return JsonNodeDecoder.toArbitrary(this.decodeNode());
    }

    @NonNull
    public JsonNode decodeNode() throws IOException {
        JsonNode node = this.peekValue();
        this.skipValue();
        return node;
    }

    private static Object toArbitrary(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        if (node.isNumber()) {
            return node.getNumberValue();
        }
        if (node.isBoolean()) {
            return node.getBooleanValue();
        }
        if (node.isString()) {
            return node.getStringValue();
        }
        if (node.isArray()) {
            ArrayList<Object> transformed = new ArrayList<Object>(node.size());
            for (JsonNode value : node.values()) {
                transformed.add(JsonNodeDecoder.toArbitrary(value));
            }
            return transformed;
        }
        if (node.isObject()) {
            LinkedHashMap transformed = CollectionUtils.newLinkedHashMap((int)node.size());
            for (Map.Entry entry : node.entries()) {
                transformed.put((String)entry.getKey(), JsonNodeDecoder.toArbitrary((JsonNode)entry.getValue()));
            }
            return transformed;
        }
        throw new AssertionError(node);
    }

    public Decoder decodeBuffer() throws IOException {
        JsonNode peeked = this.peekValue();
        this.skipValue();
        return new Buffered(peeked, this.ourLimits());
    }

    public IOException createDeserializationException(String message, Object invalidValue) {
        if (invalidValue != null) {
            return new InvalidFormatException(message, null, invalidValue);
        }
        return new SerdeException(message);
    }

    static final class Buffered
    extends JsonNodeDecoder {
        private final JsonNode node;
        private boolean complete = false;

        Buffered(JsonNode node, LimitingStream.RemainingLimits remainingLimits) {
            super(remainingLimits);
            this.node = node;
        }

        public boolean hasNextArrayValue() {
            return false;
        }

        public String decodeKey() {
            throw new IllegalStateException("Can't be called on buffered node");
        }

        public void skipValue() {
            if (this.complete) {
                throw new IllegalStateException("Already drained");
            }
            this.complete = true;
        }

        public void finishStructure(boolean consumeLeftElements) {
            throw new IllegalStateException("Can't be called on buffered node");
        }

        @Override
        protected JsonNode peekValue() {
            return this.node;
        }
    }
}

