/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.jetty;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.servlet.engine.DefaultMicronautServlet;
import io.micronaut.servlet.engine.MicronautServletConfiguration;
import io.micronaut.servlet.engine.server.ServletServerFactory;
import io.micronaut.servlet.engine.server.ServletStaticResourceConfiguration;
import io.micronaut.servlet.jetty.JettyConfiguration;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@Factory
public class JettyFactory
extends ServletServerFactory {
    public static final String RESOURCE_BASE = "resourceBase";
    private final JettyConfiguration jettyConfiguration;

    public JettyFactory(ResourceResolver resourceResolver, JettyConfiguration serverConfiguration, SslConfiguration sslConfiguration, ApplicationContext applicationContext, List<ServletStaticResourceConfiguration> staticResourceConfigurations) {
        super(resourceResolver, (HttpServerConfiguration)serverConfiguration, sslConfiguration, applicationContext, staticResourceConfigurations);
        this.jettyConfiguration = serverConfiguration;
    }

    @Singleton
    @Primary
    protected Server jettyServer(ApplicationContext applicationContext, MicronautServletConfiguration configuration) {
        List mappings;
        ResourceCollection resourceCollection;
        String host = this.getConfiguredHost();
        Integer port = this.getConfiguredPort();
        Server server = new Server();
        String contextPath = this.getContextPath();
        List src = this.getStaticResourceConfigurations();
        if (CollectionUtils.isNotEmpty((Collection)src)) {
            final List mappings2 = src.stream().map(ServletStaticResourceConfiguration::getMapping).map(path -> {
                if (path.endsWith("/**")) {
                    return path.substring(0, path.length() - 3);
                }
                return path;
            }).collect(Collectors.toList());
            resourceCollection = new ResourceCollection((Resource[])src.stream().flatMap(config -> {
                List paths = config.getPaths();
                return paths.stream().map(path -> {
                    if (path.startsWith("classpath:")) {
                        String cp = path.substring("classpath:".length());
                        return Resource.newClassPathResource((String)cp);
                    }
                    try {
                        return Resource.newResource((String)path);
                    }
                    catch (IOException e) {
                        throw new ConfigurationException("Static resource path doesn't exist: " + path, (Throwable)e);
                    }
                });
            }).toArray(Resource[]::new)){

                public Resource addPath(String path) throws IOException {
                    for (String mapping : mappings2) {
                        if (!path.startsWith(mapping)) continue;
                        path = path.substring(mapping.length());
                    }
                    return super.addPath(path);
                }
            };
        } else {
            resourceCollection = null;
        }
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)server, contextPath, false, false){

            public Resource newResource(String urlOrPath) throws IOException {
                if (resourceCollection != null && JettyFactory.RESOURCE_BASE.endsWith(urlOrPath)) {
                    return resourceCollection;
                }
                return super.newResource(urlOrPath);
            }
        };
        ServletHolder servletHolder = new ServletHolder((Servlet)new DefaultMicronautServlet(applicationContext));
        contextHandler.addServlet(servletHolder, configuration.getMapping());
        servletHolder.setAsyncSupported(true);
        configuration.getMultipartConfigElement().ifPresent(multipartConfiguration -> servletHolder.getRegistration().setMultipartConfig(multipartConfiguration));
        if (CollectionUtils.isNotEmpty((Collection)src) && CollectionUtils.isNotEmpty(mappings = src.stream().map(config -> {
            String mapping = config.getMapping();
            if (mapping.endsWith("**")) {
                return mapping.substring(0, mapping.length() - 1);
            }
            if (!mapping.endsWith("/*")) {
                return mapping + "/*";
            }
            return mapping;
        }).collect(Collectors.toList()))) {
            ServletHolder defaultServletHolder = new ServletHolder(configuration.getName(), (Servlet)new DefaultServlet());
            defaultServletHolder.setInitParameters(this.jettyConfiguration.getInitParameters());
            contextHandler.addServlet(defaultServletHolder, (String)mappings.iterator().next());
            contextHandler.setBaseResource((Resource)resourceCollection);
            ServletHandler servletHandler = defaultServletHolder.getServletHandler();
            if (mappings.size() > 1) {
                ServletMapping m = new ServletMapping();
                m.setServletName(configuration.getName());
                m.setPathSpecs(mappings.subList(1, mappings.size()).toArray(StringUtils.EMPTY_STRING_ARRAY));
                servletHandler.addServletMapping(m);
            }
            defaultServletHolder.setInitParameter(RESOURCE_BASE, RESOURCE_BASE);
            defaultServletHolder.setInitParameter("dirAllowed", "false");
        }
        server.setHandler((Handler)contextHandler);
        SslConfiguration sslConfiguration = this.getSslConfiguration();
        if (sslConfiguration.isEnabled()) {
            HttpConfiguration httpConfig = this.jettyConfiguration.getHttpConfiguration();
            int securePort = sslConfiguration.getPort();
            if (securePort == 8443 && this.getEnvironment().getActiveNames().contains("test")) {
                securePort = SocketUtils.findAvailableTcpPort();
            }
            httpConfig.setSecurePort(securePort);
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            ClientAuthentication clientAuth = sslConfiguration.getClientAuthentication().orElse(ClientAuthentication.NEED);
            switch (clientAuth) {
                case WANT: {
                    sslContextFactory.setWantClientAuth(true);
                    break;
                }
                default: {
                    sslContextFactory.setNeedClientAuth(true);
                }
            }
            sslConfiguration.getProtocol().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setProtocol(arg_0));
            sslConfiguration.getProtocols().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setIncludeProtocols(arg_0));
            sslConfiguration.getCiphers().ifPresent(arg_0 -> ((SslConfiguration)sslConfiguration).setCiphers(arg_0));
            SslConfiguration.KeyStoreConfiguration keyStoreConfig = sslConfiguration.getKeyStore();
            keyStoreConfig.getPassword().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setKeyStorePassword(arg_0));
            keyStoreConfig.getPath().ifPresent(path -> {
                if (path.startsWith("classpath:")) {
                    String cp = path.substring("classpath:".length());
                    sslContextFactory.setKeyStorePath(Resource.newClassPathResource((String)cp).getURI().toString());
                } else {
                    sslContextFactory.setKeyStorePath(path);
                }
            });
            keyStoreConfig.getProvider().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setKeyStoreProvider(arg_0));
            keyStoreConfig.getType().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setKeyStoreType(arg_0));
            SslConfiguration.TrustStoreConfiguration trustStore = sslConfiguration.getTrustStore();
            trustStore.getPassword().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setTrustStorePassword(arg_0));
            trustStore.getType().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setTrustStoreType(arg_0));
            trustStore.getPath().ifPresent(path -> {
                if (path.startsWith("classpath:")) {
                    String cp = path.substring("classpath:".length());
                    sslContextFactory.setTrustStorePath(Resource.newClassPathResource((String)cp).getURI().toString());
                } else {
                    sslContextFactory.setTrustStorePath(path);
                }
            });
            trustStore.getProvider().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setTrustStoreProvider(arg_0));
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
            https.setPort(securePort);
            server.addConnector((Connector)https);
        }
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(this.jettyConfiguration.getHttpConfiguration())});
        http.setPort(port.intValue());
        http.setHost(host);
        server.addConnector((Connector)http);
        return server;
    }
}

