/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.jetty;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.servlet.engine.DefaultMicronautServlet;
import io.micronaut.servlet.engine.MicronautServletConfiguration;
import io.micronaut.servlet.engine.server.ServletServerFactory;
import io.micronaut.servlet.engine.server.ServletStaticResourceConfiguration;
import io.micronaut.servlet.jetty.JettyConfiguration;
import jakarta.inject.Singleton;
import jakarta.servlet.Servlet;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class JettyFactory
extends ServletServerFactory {
    public static final String RESOURCE_BASE = "resourceBase";
    private static final Logger LOG = LoggerFactory.getLogger(JettyFactory.class);
    private final JettyConfiguration jettyConfiguration;

    public JettyFactory(ResourceResolver resourceResolver, JettyConfiguration serverConfiguration, SslConfiguration sslConfiguration, ApplicationContext applicationContext, List<ServletStaticResourceConfiguration> staticResourceConfigurations) {
        super(resourceResolver, (HttpServerConfiguration)serverConfiguration, sslConfiguration, applicationContext, staticResourceConfigurations);
        this.jettyConfiguration = serverConfiguration;
    }

    @Singleton
    @Primary
    protected Server jettyServer(ApplicationContext applicationContext, MicronautServletConfiguration configuration, JettyConfiguration.JettySslConfiguration jettySslConfiguration) {
        String host = this.getConfiguredHost();
        Integer port = this.getConfiguredPort();
        String contextPath = this.getContextPath();
        Server server = new Server();
        ServletContextHandler contextHandler = new ServletContextHandler((HandlerContainer)server, contextPath, false, false);
        ServletHolder servletHolder = new ServletHolder((Servlet)new DefaultMicronautServlet(applicationContext));
        contextHandler.addServlet(servletHolder, configuration.getMapping());
        Boolean isAsync = (Boolean)applicationContext.getEnvironment().getProperty("micronaut.server.testing.async", Boolean.class, (Object)true);
        if (Boolean.FALSE.equals(isAsync)) {
            LOG.warn("Async support disabled for testing purposes.");
        }
        servletHolder.setAsyncSupported(isAsync.booleanValue());
        configuration.getMultipartConfigElement().ifPresent(multipartConfiguration -> servletHolder.getRegistration().setMultipartConfig(multipartConfiguration));
        List<ServletContextHandler> resourceHandlers = Stream.concat(this.getStaticResourceConfigurations().stream().map(this::toHandler), Stream.of(contextHandler)).toList();
        HandlerList handlerList = new HandlerList((Handler[])resourceHandlers.toArray(new ContextHandler[0]));
        server.setHandler((Handler)handlerList);
        SslConfiguration sslConfiguration = this.getSslConfiguration();
        if (sslConfiguration.isEnabled()) {
            HttpConfiguration httpConfig = this.jettyConfiguration.getHttpConfiguration();
            int securePort = sslConfiguration.getPort();
            if (securePort == 8443 && this.getEnvironment().getActiveNames().contains("test")) {
                securePort = SocketUtils.findAvailableTcpPort();
            }
            httpConfig.setSecurePort(securePort);
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            ClientAuthentication clientAuth = sslConfiguration.getClientAuthentication().orElse(ClientAuthentication.NEED);
            switch (clientAuth) {
                case WANT: {
                    sslContextFactory.setWantClientAuth(true);
                    break;
                }
                default: {
                    sslContextFactory.setNeedClientAuth(true);
                }
            }
            sslConfiguration.getProtocol().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setProtocol(arg_0));
            sslConfiguration.getProtocols().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setIncludeProtocols(arg_0));
            sslConfiguration.getCiphers().ifPresent(arg_0 -> ((SslConfiguration)sslConfiguration).setCiphers(arg_0));
            SslConfiguration.KeyStoreConfiguration keyStoreConfig = sslConfiguration.getKeyStore();
            keyStoreConfig.getPassword().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setKeyStorePassword(arg_0));
            keyStoreConfig.getPath().ifPresent(path -> {
                if (path.startsWith("classpath:")) {
                    String cp = path.substring("classpath:".length());
                    sslContextFactory.setKeyStorePath(Resource.newClassPathResource((String)cp).getURI().toString());
                } else {
                    sslContextFactory.setKeyStorePath(path);
                }
            });
            keyStoreConfig.getProvider().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setKeyStoreProvider(arg_0));
            keyStoreConfig.getType().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setKeyStoreType(arg_0));
            SslConfiguration.TrustStoreConfiguration trustStore = sslConfiguration.getTrustStore();
            trustStore.getPassword().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setTrustStorePassword(arg_0));
            trustStore.getType().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setTrustStoreType(arg_0));
            trustStore.getPath().ifPresent(path -> {
                if (path.startsWith("classpath:")) {
                    String cp = path.substring("classpath:".length());
                    sslContextFactory.setTrustStorePath(Resource.newClassPathResource((String)cp).getURI().toString());
                } else {
                    sslContextFactory.setTrustStorePath(path);
                }
            });
            trustStore.getProvider().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setTrustStoreProvider(arg_0));
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)jettySslConfiguration);
            ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
            https.setPort(securePort);
            server.addConnector((Connector)https);
        }
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(this.jettyConfiguration.getHttpConfiguration())});
        http.setPort(port.intValue());
        http.setHost(host);
        server.addConnector((Connector)http);
        return server;
    }

    private ContextHandler toHandler(ServletStaticResourceConfiguration config) {
        Resource[] resourceArray = (Resource[])config.getPaths().stream().map(path -> {
            if (path.startsWith("classpath:")) {
                String cp = path.substring("classpath:".length());
                return Resource.newClassPathResource((String)cp);
            }
            try {
                return Resource.newResource((String)path);
            }
            catch (IOException e) {
                throw new ConfigurationException("Static resource path doesn't exist: " + path, (Throwable)e);
            }
        }).toArray(Resource[]::new);
        String path2 = config.getMapping();
        if (path2.endsWith("/**")) {
            path2 = path2.substring(0, path2.length() - 3);
        }
        final String mapping = path2;
        ResourceCollection mappedResourceCollection = new ResourceCollection(resourceArray){

            public Resource addPath(String path) throws IOException {
                return super.addPath(path.substring(mapping.length()));
            }
        };
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setBaseResource((Resource)mappedResourceCollection);
        resourceHandler.setDirAllowed(false);
        resourceHandler.setDirectoriesListed(false);
        if (!StringUtils.isEmpty((CharSequence)config.getCacheControl())) {
            resourceHandler.setCacheControl(config.getCacheControl());
        }
        ContextHandler contextHandler = new ContextHandler(path2);
        contextHandler.setContextPath("/");
        contextHandler.setHandler((Handler)resourceHandler);
        contextHandler.setDisplayName("Static Resources " + mapping);
        return contextHandler;
    }
}

