/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.jetty;

import io.micronaut.context.ApplicationContext;
import io.micronaut.http.server.exceptions.HttpServerException;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.servlet.engine.server.AbstractServletServer;
import jakarta.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.jetty.server.Server;

@Singleton
public class JettyServer
extends AbstractServletServer<Server> {
    public JettyServer(ApplicationContext applicationContext, ApplicationConfiguration applicationConfiguration, Server server) {
        super(applicationContext, applicationConfiguration, (Object)server);
    }

    protected void startServer() throws Exception {
        ((Server)this.getServer()).start();
    }

    protected void stopServer() throws Exception {
        ((Server)this.getServer()).stop();
    }

    public int getPort() {
        return ((Server)this.getServer()).getURI().getPort();
    }

    public String getHost() {
        return ((Server)this.getServer()).getURI().getHost();
    }

    public String getScheme() {
        return ((Server)this.getServer()).getURI().getScheme();
    }

    public URL getURL() {
        try {
            return ((Server)this.getServer()).getURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new HttpServerException(e.getMessage(), (Throwable)e);
        }
    }

    public URI getURI() {
        return ((Server)this.getServer()).getURI();
    }

    public boolean isRunning() {
        return ((Server)this.getServer()).isRunning();
    }
}

