/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.jetty;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.http.server.HttpServerConfiguration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.SecureRequestCustomizer;

@ConfigurationProperties(value="jetty")
@Replaces(value=HttpServerConfiguration.class)
public class JettyConfiguration
extends HttpServerConfiguration {
    @ConfigurationBuilder
    protected HttpConfiguration httpConfiguration = new HttpConfiguration();
    private final HttpServerConfiguration.MultipartConfiguration multipartConfiguration;
    private Map<String, String> initParameters;

    public JettyConfiguration(@Nullable HttpServerConfiguration.MultipartConfiguration multipartConfiguration) {
        this.multipartConfiguration = multipartConfiguration;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public Optional<HttpServerConfiguration.MultipartConfiguration> getMultipartConfiguration() {
        return Optional.ofNullable(this.multipartConfiguration);
    }

    public Map<String, String> getInitParameters() {
        if (this.initParameters != null) {
            return Collections.unmodifiableMap(this.initParameters);
        }
        return Collections.emptyMap();
    }

    public void setInitParameters(@MapFormat(transformation=MapFormat.MapTransformation.FLAT, keyFormat=StringConvention.RAW) Map<String, String> initParameters) {
        if (initParameters != null) {
            this.initParameters = initParameters;
        }
    }

    @ConfigurationProperties(value="ssl")
    public static class JettySslConfiguration
    extends SecureRequestCustomizer {
    }
}

