/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.jetty;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.util.Toggleable;
import io.micronaut.http.server.HttpServerConfiguration;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

@ConfigurationProperties(value="jetty")
@Replaces(value=HttpServerConfiguration.class)
public class JettyConfiguration
extends HttpServerConfiguration {
    @ConfigurationBuilder
    protected HttpConfiguration httpConfiguration = new HttpConfiguration();
    private final JettyRequestLog requestLog;
    private final HttpServerConfiguration.MultipartConfiguration multipartConfiguration;
    private Map<String, String> initParameters;

    public JettyConfiguration(@Nullable HttpServerConfiguration.MultipartConfiguration multipartConfiguration) {
        this(null, null);
    }

    @Inject
    public JettyConfiguration(@Nullable HttpServerConfiguration.MultipartConfiguration multipartConfiguration, @Nullable JettyRequestLog requestLog) {
        this.multipartConfiguration = multipartConfiguration;
        this.requestLog = requestLog;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public Optional<HttpServerConfiguration.MultipartConfiguration> getMultipartConfiguration() {
        return Optional.ofNullable(this.multipartConfiguration);
    }

    public Optional<JettyRequestLog> getRequestLog() {
        return Optional.ofNullable(this.requestLog);
    }

    public Map<String, String> getInitParameters() {
        if (this.initParameters != null) {
            return Collections.unmodifiableMap(this.initParameters);
        }
        return Collections.emptyMap();
    }

    public void setInitParameters(@MapFormat(transformation=MapFormat.MapTransformation.FLAT, keyFormat=StringConvention.RAW) Map<String, String> initParameters) {
        if (initParameters != null) {
            this.initParameters = initParameters;
        }
    }

    @ConfigurationProperties(value="access-log")
    @Requires(property="micronaut.server.jetty.access-log.enabled", value="true")
    public static final class JettyRequestLog
    implements Toggleable {
        public static final String ACCESS_LOG = "access-log";
        public static final String ENABLED_PROPERTY = "micronaut.server.jetty.access-log.enabled";
        @ConfigurationBuilder(prefixes={"set"}, excludes={"eventListeners"})
        RequestLogWriter requestLogWriter = new RequestLogWriter();
        private boolean enabled = true;
        private String pattern = "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"";
        private String fileName;
        private String resourcePath = "/logback-access.xml";
        private boolean quiet = true;

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        public boolean isQuiet() {
            return this.quiet;
        }

        public void setQuiet(boolean quiet) {
            this.quiet = quiet;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @NonNull
        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }

    @ConfigurationProperties(value="ssl")
    public static class JettySslConfiguration
    extends SecureRequestCustomizer {
    }

    @EachProperty(value="connectors", excludes={"beans", "eventListeners", "connectionFactories"})
    public static class ConnectorConfiguration
    extends ServerConnector {
        private boolean sslEnabled = true;

        public ConnectorConfiguration(@Parameter String name, Server server) {
            super(server, new ConnectionFactory[0]);
            this.setName(name);
        }

        public boolean isSslEnabled() {
            return this.sslEnabled;
        }

        public void setSslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
        }
    }
}

