/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.jetty;

import ch.qos.logback.access.jetty.RequestLogImpl;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.scheduling.LoomSupport;
import io.micronaut.servlet.engine.MicronautServletConfiguration;
import io.micronaut.servlet.http.server.ServletServerFactory;
import io.micronaut.servlet.http.server.ServletStaticResourceConfiguration;
import io.micronaut.servlet.jetty.JettyConfiguration;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletContainerInitializer;
import java.security.KeyStore;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

@Factory
public class JettyFactory
extends ServletServerFactory {
    private final JettyConfiguration jettyConfiguration;

    public JettyFactory(ResourceResolver resourceResolver, JettyConfiguration serverConfiguration, SslConfiguration sslConfiguration, ApplicationContext applicationContext, List<ServletStaticResourceConfiguration> staticResourceConfigurations) {
        super(resourceResolver, (HttpServerConfiguration)serverConfiguration, sslConfiguration, applicationContext, staticResourceConfigurations);
        this.jettyConfiguration = serverConfiguration;
    }

    protected Server jettyServer(ApplicationContext applicationContext, MicronautServletConfiguration configuration, JettyConfiguration.JettySslConfiguration jettySslConfiguration) throws Exception {
        return this.jettyServer(applicationContext, configuration, jettySslConfiguration, applicationContext.getBeansOfType(ServletContainerInitializer.class));
    }

    protected Server jettyServer(ApplicationContext applicationContext, MicronautServletConfiguration configuration, JettyConfiguration.JettySslConfiguration jettySslConfiguration, Collection<ServletContainerInitializer> servletContainerInitializers) throws Exception {
        return this.jettyServer(applicationContext, configuration, jettySslConfiguration, applicationContext.getBeansOfType(ServletContainerInitializer.class), null);
    }

    @Singleton
    @Primary
    protected Server jettyServer(ApplicationContext applicationContext, MicronautServletConfiguration configuration, JettyConfiguration.JettySslConfiguration jettySslConfiguration, Collection<ServletContainerInitializer> servletContainerInitializers, @Nullable RequestLog requestLog) throws Exception {
        String host = this.getConfiguredHost();
        Integer port = this.getConfiguredPort();
        String contextPath = this.getContextPath();
        Server server = this.newServer(applicationContext, configuration);
        if (requestLog != null) {
            server.setRequestLog(requestLog);
        }
        ServletContextHandler contextHandler = this.newJettyContext(server, contextPath);
        server.setHandler((Handler)contextHandler);
        this.configureServletInitializer(server, contextHandler, servletContainerInitializers);
        ResourceFactory resourceFactory = ResourceFactory.of((Container)server);
        SslConfiguration sslConfiguration = this.getSslConfiguration();
        ServerConnector https = null;
        if (sslConfiguration.isEnabled()) {
            https = this.newHttpsConnector(server, sslConfiguration, jettySslConfiguration, resourceFactory);
        }
        ServerConnector http = this.newHttpConnector(server, host, port);
        this.configureConnectors(server, http, https);
        return server;
    }

    @Singleton
    @Requires(property="micronaut.server.jetty.access-log.enabled", value="true")
    RequestLog requestLog(JettyConfiguration.JettyRequestLog jettyRequestLog) {
        return new CustomRequestLog((RequestLog.Writer)jettyRequestLog.requestLogWriter, jettyRequestLog.getPattern());
    }

    @Singleton
    @Primary
    @Requirements(value={@Requires(property="micronaut.server.jetty.access-log.enabled", value="true"), @Requires(classes={RequestLogImpl.class})})
    RequestLog requestLogImpl(JettyConfiguration.JettyRequestLog jettyRequestLog) {
        RequestLogImpl requestLog = new RequestLogImpl();
        requestLog.setResource(jettyRequestLog.getResourcePath());
        requestLog.setQuiet(jettyRequestLog.isQuiet());
        requestLog.setFileName(jettyRequestLog.getFileName());
        return requestLog;
    }

    @NonNull
    protected ServerConnector newHttpConnector(@NonNull Server server, @NonNull String host, @NonNull Integer port) {
        ServerConnector http;
        HttpConfiguration httpConfig = this.jettyConfiguration.getHttpConfiguration();
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpConfig);
        HttpServerConfiguration serverConfiguration = this.getServerConfiguration();
        if (serverConfiguration.getHttpVersion() == io.micronaut.http.HttpVersion.HTTP_2_0) {
            HTTP2CServerConnectionFactory h2c = new HTTP2CServerConnectionFactory(httpConfig);
            http = new ServerConnector(server, new ConnectionFactory[]{http11, h2c});
        } else {
            http = new ServerConnector(server, new ConnectionFactory[]{http11});
        }
        http.setPort(port.intValue());
        http.setHost(host);
        return http;
    }

    @NonNull
    protected ServerConnector newHttpsConnector(@NonNull Server server, @NonNull SslConfiguration sslConfiguration, @NonNull JettyConfiguration.JettySslConfiguration jettySslConfiguration, ResourceFactory resourceFactory) throws Exception {
        ServerConnector https;
        HttpConfiguration httpConfig = this.jettyConfiguration.getHttpConfiguration();
        int securePort = sslConfiguration.getPort();
        if (securePort == 8443 && this.getEnvironment().getActiveNames().contains("test")) {
            securePort = 0;
        }
        httpConfig.setSecurePort(securePort);
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        ClientAuthentication clientAuth = sslConfiguration.getClientAuthentication().orElse(ClientAuthentication.NEED);
        switch (clientAuth) {
            case WANT: {
                sslContextFactory.setWantClientAuth(true);
                break;
            }
            default: {
                sslContextFactory.setNeedClientAuth(true);
            }
        }
        sslConfiguration.getProtocol().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setProtocol(arg_0));
        sslConfiguration.getProtocols().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setIncludeProtocols(arg_0));
        sslConfiguration.getCiphers().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setIncludeCipherSuites(arg_0));
        this.configureKeyStore(sslConfiguration, sslContextFactory, resourceFactory);
        this.configureTrustStore(sslConfiguration, sslContextFactory, resourceFactory);
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)jettySslConfiguration);
        HttpConnectionFactory http11 = new HttpConnectionFactory(httpsConfig);
        if (this.getServerConfiguration().getHttpVersion() == io.micronaut.http.HttpVersion.HTTP_2_0) {
            HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpConfig);
            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
            alpn.setDefaultProtocol(http11.getProtocol());
            SslConnectionFactory tls = new SslConnectionFactory(sslContextFactory, alpn.getProtocol());
            https = new ServerConnector(server, new ConnectionFactory[]{tls, alpn, h2, http11});
        } else {
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
            https = new ServerConnector(server, new ConnectionFactory[]{sslConnectionFactory, http11});
        }
        https.setPort(securePort);
        return https;
    }

    protected void configureKeyStore(SslConfiguration sslConfiguration, SslContextFactory.Server sslContextFactory, ResourceFactory resourceFactory) throws Exception {
        Optional keyStore = this.getKeyStore(sslConfiguration);
        if (keyStore.isPresent()) {
            sslContextFactory.setKeyStore((KeyStore)keyStore.get());
        } else {
            SslConfiguration.KeyStoreConfiguration keyStoreConfig = sslConfiguration.getKeyStore();
            keyStoreConfig.getPassword().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setKeyStorePassword(arg_0));
            keyStoreConfig.getPath().ifPresent(path -> sslContextFactory.setKeyStorePath(this.resolveStorePath((String)path, resourceFactory)));
            keyStoreConfig.getProvider().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setKeyStoreProvider(arg_0));
            keyStoreConfig.getType().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setKeyStoreType(arg_0));
        }
    }

    protected void configureTrustStore(SslConfiguration sslConfiguration, SslContextFactory.Server sslContextFactory, ResourceFactory resourceFactory) throws Exception {
        Optional trustStore = this.getTrustStore(sslConfiguration);
        if (trustStore.isPresent()) {
            sslContextFactory.setTrustStore((KeyStore)trustStore.get());
        } else {
            SslConfiguration.TrustStoreConfiguration trustStoreConfig = sslConfiguration.getTrustStore();
            trustStoreConfig.getPassword().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setTrustStorePassword(arg_0));
            trustStoreConfig.getPath().ifPresent(path -> sslContextFactory.setTrustStorePath(this.resolveStorePath((String)path, resourceFactory)));
            trustStoreConfig.getProvider().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setTrustStoreProvider(arg_0));
            trustStoreConfig.getType().ifPresent(arg_0 -> ((SslContextFactory.Server)sslContextFactory).setTrustStoreType(arg_0));
        }
    }

    protected void configureServletInitializer(Server server, ServletContextHandler contextHandler, Collection<ServletContainerInitializer> servletContainerInitializers) {
        for (ServletContainerInitializer servletContainerInitializer : servletContainerInitializers) {
            contextHandler.addServletContainerInitializer(servletContainerInitializer);
        }
        List<ContextHandler> resourceHandlers = Stream.concat(Stream.of(contextHandler), this.getStaticResourceConfigurations().stream().map(servletStaticResourceConfiguration -> this.toHandler((ServletStaticResourceConfiguration)servletStaticResourceConfiguration, ResourceFactory.of((Container)contextHandler)))).toList();
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection(resourceHandlers.toArray(new ContextHandler[0]));
        server.setHandler((Handler)contextHandlerCollection);
    }

    @NonNull
    protected ServletContextHandler newJettyContext(@NonNull Server server, @NonNull String contextPath) {
        return new ServletContextHandler(contextPath, false, false);
    }

    protected void configureConnectors(@NonNull Server server, @NonNull ServerConnector http, @Nullable ServerConnector https) {
        HttpServerConfiguration serverConfiguration = this.getServerConfiguration();
        if (https != null) {
            server.addConnector((Connector)https);
            if (serverConfiguration.isDualProtocol()) {
                server.addConnector((Connector)http);
            }
        } else {
            server.addConnector((Connector)http);
        }
    }

    @NonNull
    protected Server newServer(@NonNull ApplicationContext applicationContext, @NonNull MicronautServletConfiguration configuration) {
        QueuedThreadPool threadPool = configuration.getMaxThreads() != null ? (configuration.getMinThreads() != null ? new QueuedThreadPool(configuration.getMaxThreads().intValue(), configuration.getMinThreads().intValue()) : new QueuedThreadPool(configuration.getMaxThreads().intValue())) : new QueuedThreadPool();
        if (configuration.isEnableVirtualThreads() && LoomSupport.isSupported()) {
            threadPool.setVirtualThreadsExecutor((Executor)applicationContext.getBean(ExecutorService.class, Qualifiers.byName((String)"blocking")));
        }
        return new Server((ThreadPool)threadPool);
    }

    private ContextHandler toHandler(ServletStaticResourceConfiguration config, ResourceFactory resourceFactory) {
        ResourceHandler resourceHandler = new ResourceHandler();
        Resource[] resourceArray = (Resource[])config.getPaths().stream().map(path -> {
            Resource resource;
            if (path.startsWith("classpath:")) {
                String cp = path.substring("classpath:".length());
                resource = resourceFactory.newClassLoaderResource(cp);
            } else {
                try {
                    resource = resourceFactory.newResource(path);
                }
                catch (Exception e) {
                    throw new ConfigurationException("Static resource path doesn't exist: " + path, (Throwable)e);
                }
            }
            if (resource == null || !resource.exists()) {
                throw new ConfigurationException("Static resource path doesn't exist: " + path);
            }
            return resource;
        }).toArray(Resource[]::new);
        String path2 = config.getMapping();
        if (path2.endsWith("/**")) {
            path2 = path2.substring(0, path2.length() - 3);
        }
        String mapping = path2;
        Resource combined = ResourceFactory.combine((Resource[])resourceArray);
        resourceHandler.setBaseResource(combined);
        resourceHandler.setDirAllowed(false);
        if (!StringUtils.isEmpty((CharSequence)config.getCacheControl())) {
            resourceHandler.setCacheControl(config.getCacheControl());
        }
        ContextHandler contextHandler = new ContextHandler(path2);
        contextHandler.setHandler((Handler)resourceHandler);
        contextHandler.setDisplayName("Static Resources " + mapping);
        return contextHandler;
    }

    private String resolveStorePath(String path, ResourceFactory resourceFactory) {
        if (path.startsWith("classpath:")) {
            String cp = path.substring("classpath:".length());
            return resourceFactory.newClassLoaderResource(cp).getURI().toString();
        }
        return path;
    }
}

