/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.jetty;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.server.exceptions.HttpServerException;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.event.ServerShutdownEvent;
import io.micronaut.servlet.http.server.AbstractServletServer;
import io.micronaut.servlet.jetty.JettyConfiguration;
import io.micronaut.web.router.Router;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

@Singleton
public class JettyServer
extends AbstractServletServer<Server> {
    private final Router router;

    @Inject
    public JettyServer(ApplicationContext applicationContext, ApplicationConfiguration applicationConfiguration, Server server, Router router, JettyConfiguration jettyConfiguration, List<JettyConfiguration.ConnectorConfiguration> connectors, @Nullable ApplicationEventPublisher<ServerShutdownEvent> serverShutdownEventPublisher) {
        super(applicationContext, applicationConfiguration, serverShutdownEventPublisher, (Object)server);
        this.router = router;
        this.applyConnectorConfiguration(jettyConfiguration, server, connectors);
    }

    @Deprecated(forRemoval=true, since="5.0")
    public JettyServer(ApplicationContext applicationContext, ApplicationConfiguration applicationConfiguration, Server server) {
        this(applicationContext, applicationConfiguration, server, (Router)applicationContext.getBean(Router.class), (JettyConfiguration)((Object)applicationContext.getBean(JettyConfiguration.class)), new ArrayList<JettyConfiguration.ConnectorConfiguration>(applicationContext.getBeansOfType(JettyConfiguration.ConnectorConfiguration.class)), null);
    }

    @Deprecated(forRemoval=true, since="5.2.0")
    public JettyServer(ApplicationContext applicationContext, ApplicationConfiguration applicationConfiguration, Server server, Router router, JettyConfiguration jettyConfiguration, List<JettyConfiguration.ConnectorConfiguration> connectors) {
        this(applicationContext, applicationConfiguration, server, router, jettyConfiguration, connectors, null);
    }

    protected void startServer() throws Exception {
        Server server = (Server)this.getServer();
        server.start();
    }

    protected void stopServer() throws Exception {
        ((Server)this.getServer()).stop();
    }

    public int getPort() {
        Server server = (Server)this.getServer();
        return server.getURI().getPort();
    }

    public String getHost() {
        return ((Server)this.getServer()).getURI().getHost();
    }

    public String getScheme() {
        return ((Server)this.getServer()).getURI().getScheme();
    }

    public URL getURL() {
        try {
            return ((Server)this.getServer()).getURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new HttpServerException(e.getMessage(), (Throwable)e);
        }
    }

    public URI getURI() {
        return ((Server)this.getServer()).getURI();
    }

    public boolean isRunning() {
        return ((Server)this.getServer()).isRunning();
    }

    private void applyConnectorConfiguration(JettyConfiguration jettyConfiguration, Server server, List<JettyConfiguration.ConnectorConfiguration> configuredConnectors) {
        Connector[] serverConnectors = server.getConnectors();
        ServerConnector serverConnector = (ServerConnector)serverConnectors[0];
        ArrayList<JettyConfiguration.ConnectorConfiguration> connectorConfigurations = new ArrayList<JettyConfiguration.ConnectorConfiguration>(configuredConnectors);
        this.applyAdditionalPorts(jettyConfiguration, server, serverConnector, connectorConfigurations);
        for (Connector connector : serverConnectors) {
            if (!(connector instanceof ServerConnector)) continue;
            ServerConnector sc = (ServerConnector)connector;
            connectorConfigurations.stream().filter(cc -> cc.getPort() == sc.getPort()).findFirst().ifPresent(connectorConfiguration -> JettyServer.configureExistingConnector(sc, connectorConfigurations, connectorConfiguration));
        }
        for (JettyConfiguration.ConnectorConfiguration connector : connectorConfigurations) {
            server.addConnector((Connector)connector);
        }
    }

    private static void configureExistingConnector(ServerConnector sc, List<JettyConfiguration.ConnectorConfiguration> connectorConfigurations, JettyConfiguration.ConnectorConfiguration connectorConfiguration) {
        connectorConfigurations.remove((Object)connectorConfiguration);
        sc.setHost(connectorConfiguration.getHost());
        sc.setAccepting(connectorConfiguration.isAccepting());
        sc.setInheritChannel(connectorConfiguration.isInheritChannel());
        sc.setAcceptedReceiveBufferSize(connectorConfiguration.getAcceptedReceiveBufferSize());
        sc.setAcceptedTcpNoDelay(connectorConfiguration.getAcceptedTcpNoDelay());
        sc.setAcceptedSendBufferSize(connectorConfiguration.getAcceptedSendBufferSize());
        sc.setAcceptQueueSize(connectorConfiguration.getAcceptQueueSize());
        sc.setReuseAddress(connectorConfiguration.getReuseAddress());
        sc.setReusePort(connectorConfiguration.isReusePort());
        sc.setAcceptorPriorityDelta(connectorConfiguration.getAcceptorPriorityDelta());
        sc.setInheritChannel(connectorConfiguration.isInheritChannel());
        sc.setAccepting(connectorConfiguration.isAccepting());
        sc.setIdleTimeout(connectorConfiguration.getIdleTimeout());
        sc.setShutdownIdleTimeout(connectorConfiguration.getShutdownIdleTimeout());
        sc.setDefaultProtocol(connectorConfiguration.getDefaultProtocol());
    }

    private void applyAdditionalPorts(JettyConfiguration jettyConfiguration, Server server, ServerConnector serverConnector, List<JettyConfiguration.ConnectorConfiguration> connectors) {
        Set exposedPorts = this.router.getExposedPorts();
        if (CollectionUtils.isNotEmpty((Collection)exposedPorts)) {
            for (Integer exposedPort : exposedPorts) {
                if (exposedPort.equals(serverConnector.getLocalPort())) continue;
                JettyConfiguration.ConnectorConfiguration connectorConfiguration = connectors.stream().filter(c -> c.getPort() == exposedPort.intValue()).findFirst().orElse(null);
                Collection connectionFactories = serverConnector.getConnectionFactories();
                if (connectorConfiguration != null) {
                    connectors.remove((Object)connectorConfiguration);
                    JettyServer.handleConnectionConfiguration(jettyConfiguration, server, connectorConfiguration, connectionFactories, serverConnector);
                    continue;
                }
                ServerConnector connector = new ServerConnector(server, (ConnectionFactory[])connectionFactories.toArray(ConnectionFactory[]::new));
                connector.setPort(exposedPort.intValue());
                connector.setHost(serverConnector.getHost());
                server.addConnector((Connector)connector);
            }
        }
    }

    private static void handleConnectionConfiguration(JettyConfiguration jettyConfiguration, Server server, JettyConfiguration.ConnectorConfiguration connectorConfiguration, Collection<ConnectionFactory> connectionFactories, ServerConnector serverConnector) {
        String defaultProtocol = connectorConfiguration.getDefaultProtocol();
        ArrayList<ConnectionFactory> resolvedFactories = new ArrayList<ConnectionFactory>(connectionFactories);
        if (!connectorConfiguration.isSslEnabled()) {
            resolvedFactories.removeIf(cf -> cf.getProtocol().equalsIgnoreCase("SSL"));
        }
        if (defaultProtocol != null && defaultProtocol.equalsIgnoreCase(HttpVersion.HTTP_1_1.name()) && resolvedFactories.stream().noneMatch(cf -> cf.getProtocol().equalsIgnoreCase(HttpVersion.HTTP_1_1.name()))) {
            resolvedFactories.add((ConnectionFactory)new HttpConnectionFactory(jettyConfiguration.getHttpConfiguration()));
        }
        if (connectorConfiguration.getHost() == null) {
            connectorConfiguration.setHost(serverConnector.getHost());
        }
        connectorConfiguration.setConnectionFactories(resolvedFactories);
        server.addConnector((Connector)connectorConfiguration);
    }
}

