/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.tomcat;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.servlet.engine.DefaultMicronautServlet;
import io.micronaut.servlet.engine.MicronautServletConfiguration;
import io.micronaut.servlet.engine.server.ServletServerFactory;
import io.micronaut.servlet.engine.server.ServletStaticResourceConfiguration;
import io.micronaut.servlet.tomcat.TomcatConfiguration;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;

@Factory
public class TomcatFactory
extends ServletServerFactory {
    protected TomcatFactory(ResourceResolver resourceResolver, TomcatConfiguration serverConfiguration, SslConfiguration sslConfiguration, ApplicationContext applicationContext, List<ServletStaticResourceConfiguration> staticResourceConfigurations) {
        super(resourceResolver, (HttpServerConfiguration)serverConfiguration, sslConfiguration, applicationContext, staticResourceConfigurations);
    }

    public TomcatConfiguration getServerConfiguration() {
        return (TomcatConfiguration)super.getServerConfiguration();
    }

    @Singleton
    @Primary
    protected Tomcat tomcatServer(Connector connector, MicronautServletConfiguration configuration) {
        Tomcat tomcat = new Tomcat();
        tomcat.setHostname(this.getConfiguredHost());
        String contextPath = this.getContextPath();
        tomcat.getHost().setAutoDeploy(false);
        tomcat.setConnector(connector);
        String cp = contextPath != null && !contextPath.equals("/") ? contextPath : "";
        Context context = tomcat.addContext(cp, "/");
        Wrapper servlet = Tomcat.addServlet((Context)context, (String)configuration.getName(), (Servlet)new DefaultMicronautServlet(this.getApplicationContext()));
        servlet.addMapping(configuration.getMapping());
        configuration.getMultipartConfigElement().ifPresent(arg_0 -> ((Wrapper)servlet).setMultipartConfigElement(arg_0));
        SslConfiguration sslConfiguration = this.getSslConfiguration();
        if (sslConfiguration.isEnabled()) {
            String protocol = sslConfiguration.getProtocol().orElse("TLS");
            int sslPort = sslConfiguration.getPort();
            if (sslPort == 8443 && this.getEnvironment().getActiveNames().contains("test")) {
                sslPort = SocketUtils.findAvailableTcpPort();
            }
            Connector httpsConnector = new Connector();
            httpsConnector.setPort(sslPort);
            httpsConnector.setSecure(true);
            httpsConnector.setScheme("https");
            httpsConnector.setProperty("clientAuth", "false");
            httpsConnector.setProperty("sslProtocol", protocol);
            httpsConnector.setProperty("SSLEnabled", "true");
            sslConfiguration.getCiphers().ifPresent(cyphers -> httpsConnector.setAttribute("cyphers", cyphers));
            sslConfiguration.getClientAuthentication().ifPresent(ca -> {
                switch (ca) {
                    case WANT: {
                        httpsConnector.setProperty("clientAuth", "want");
                        break;
                    }
                    default: {
                        httpsConnector.setProperty("clientAuth", "true");
                    }
                }
            });
            SslConfiguration.KeyStoreConfiguration keyStoreConfig = sslConfiguration.getKeyStore();
            keyStoreConfig.getPassword().ifPresent(s -> httpsConnector.setProperty("keystorePass", s));
            keyStoreConfig.getPath().ifPresent(path -> this.setPathAttribute(httpsConnector, "keystoreFile", (String)path));
            keyStoreConfig.getProvider().ifPresent(provider -> httpsConnector.setProperty("keystoreProvider", provider));
            keyStoreConfig.getType().ifPresent(type -> httpsConnector.setProperty("keystoreType", type));
            SslConfiguration.TrustStoreConfiguration trustStore = sslConfiguration.getTrustStore();
            trustStore.getPassword().ifPresent(s -> httpsConnector.setProperty("truststorePass", s));
            trustStore.getPath().ifPresent(path -> this.setPathAttribute(httpsConnector, "truststoreFile", (String)path));
            trustStore.getProvider().ifPresent(provider -> httpsConnector.setProperty("truststoreProvider", provider));
            trustStore.getType().ifPresent(type -> httpsConnector.setProperty("truststoreType", type));
            SslConfiguration.KeyConfiguration keyConfig = sslConfiguration.getKey();
            keyConfig.getAlias().ifPresent(s -> httpsConnector.setProperty("keyAlias", s));
            keyConfig.getPassword().ifPresent(s -> httpsConnector.setProperty("keyPass", s));
            tomcat.getService().addConnector(httpsConnector);
        }
        return tomcat;
    }

    @Singleton
    @Primary
    protected Connector tomcatConnector() {
        Connector tomcatConnector = this.getServerConfiguration().getTomcatConnector();
        tomcatConnector.setPort(this.getConfiguredPort().intValue());
        return tomcatConnector;
    }

    private void setPathAttribute(Connector httpsConnector, String attributeName, String path) {
        if (path.startsWith("classpath:")) {
            String res = path.substring("classpath:".length());
            URL resource = this.getEnvironment().getClassLoader().getResource(res);
            if (resource != null) {
                httpsConnector.setProperty(attributeName, resource.toString());
            }
        } else if (path.startsWith("file:")) {
            String res = path.substring("file:".length());
            httpsConnector.setProperty(attributeName, new File(res).getAbsolutePath());
        } else {
            httpsConnector.setProperty(attributeName, new File(path).getAbsolutePath());
        }
    }

    static {
        TomcatURLStreamHandlerFactory.disable();
    }
}

