/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.tomcat;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.server.HttpServerConfiguration;
import java.util.Map;
import java.util.Optional;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.ajp.AjpAprProtocol;
import org.apache.coyote.ajp.AjpNio2Protocol;
import org.apache.coyote.ajp.AjpNioProtocol;
import org.apache.coyote.http11.Http11AprProtocol;
import org.apache.coyote.http11.Http11Nio2Protocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.coyote.http2.Http2Protocol;

@ConfigurationProperties(value="tomcat")
@TypeHint(value={TomcatConfiguration.class, Http11NioProtocol.class, Http11Nio2Protocol.class, Http11AprProtocol.class, Http2Protocol.class, AjpAprProtocol.class, AjpNio2Protocol.class, AjpNioProtocol.class})
@Primary
public class TomcatConfiguration
extends HttpServerConfiguration {
    @ConfigurationBuilder
    protected final Connector tomcatConnector;
    private final HttpServerConfiguration.MultipartConfiguration multipartConfiguration;
    private String protocol;

    public TomcatConfiguration(@Nullable HttpServerConfiguration.MultipartConfiguration multipartConfiguration, @Property(name="micronaut.server.tomcat.protocol") @Nullable String protocol) {
        this.multipartConfiguration = multipartConfiguration;
        this.tomcatConnector = new Connector(protocol != null ? protocol : "org.apache.coyote.http11.Http11NioProtocol");
    }

    public void setAttributes(@MapFormat(transformation=MapFormat.MapTransformation.FLAT, keyFormat=StringConvention.RAW) Map<String, String> attributes) {
        if (CollectionUtils.isNotEmpty(attributes)) {
            attributes.forEach((arg_0, arg_1) -> ((Connector)this.tomcatConnector).setAttribute(arg_0, arg_1));
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(@Nullable String protocol) {
        this.protocol = protocol;
    }

    public Connector getTomcatConnector() {
        return this.tomcatConnector;
    }

    public Optional<HttpServerConfiguration.MultipartConfiguration> getMultipartConfiguration() {
        return Optional.ofNullable(this.multipartConfiguration);
    }
}

