/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.tomcat;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.util.Toggleable;
import io.micronaut.http.server.HttpServerConfiguration;
import jakarta.inject.Inject;
import java.util.Optional;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.valves.ExtendedAccessLogValve;
import org.apache.coyote.ajp.AjpNio2Protocol;
import org.apache.coyote.ajp.AjpNioProtocol;
import org.apache.coyote.http11.Http11Nio2Protocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.coyote.http2.Http2Protocol;

@ConfigurationProperties(value="tomcat")
@TypeHint(value={TomcatConfiguration.class, Http11NioProtocol.class, Http11Nio2Protocol.class, Http2Protocol.class, AjpNio2Protocol.class, AjpNioProtocol.class})
@Replaces(value=HttpServerConfiguration.class)
public class TomcatConfiguration
extends HttpServerConfiguration {
    @ConfigurationBuilder
    protected final Connector tomcatConnector;
    private final HttpServerConfiguration.MultipartConfiguration multipartConfiguration;
    private String protocol;
    private AccessLogConfiguration accessLogConfiguration;

    public TomcatConfiguration(@Nullable HttpServerConfiguration.MultipartConfiguration multipartConfiguration, @Property(name="micronaut.server.tomcat.protocol") @Nullable String protocol) {
        this.multipartConfiguration = multipartConfiguration;
        this.tomcatConnector = new Connector(protocol != null ? protocol : "org.apache.coyote.http11.Http11NioProtocol");
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(@Nullable String protocol) {
        this.protocol = protocol;
    }

    public Connector getTomcatConnector() {
        return this.tomcatConnector;
    }

    public Optional<HttpServerConfiguration.MultipartConfiguration> getMultipartConfiguration() {
        return Optional.ofNullable(this.multipartConfiguration);
    }

    public Optional<AccessLogConfiguration> getAccessLogConfiguration() {
        return Optional.ofNullable(this.accessLogConfiguration);
    }

    @Inject
    public void setAccessLogConfiguration(@Nullable AccessLogConfiguration accessLogConfiguration) {
        this.accessLogConfiguration = accessLogConfiguration;
    }

    @ConfigurationProperties(value="access-log", excludes={"next", "container"})
    @Requires(property="micronaut.server.tomcat.access-log.enabled", value="true")
    public static class AccessLogConfiguration
    extends ExtendedAccessLogValve
    implements Toggleable {
        public static final String PREFIX = "access-log";
        public static final String ENABLED_PROPERTY = "micronaut.server.tomcat.access-log.enabled";

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

