/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.tomcat;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.servlet.http.ServletConfiguration;
import jakarta.inject.Singleton;
import java.util.concurrent.Executor;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.ProtocolHandler;
import org.apache.tomcat.util.threads.VirtualThreadExecutor;

@Requires(sdk=Requires.Sdk.JAVA, version="21")
@Singleton
class TomcatVirtualThreadEnabler
implements BeanCreatedEventListener<Connector> {
    private final ServletConfiguration servletConfiguration;

    public TomcatVirtualThreadEnabler(ServletConfiguration servletConfiguration) {
        this.servletConfiguration = servletConfiguration;
    }

    public Connector onCreated(@NonNull BeanCreatedEvent<Connector> event) {
        Connector connector = (Connector)event.getBean();
        if (this.servletConfiguration.isEnableVirtualThreads()) {
            ProtocolHandler protocolHandler = connector.getProtocolHandler();
            protocolHandler.setExecutor((Executor)new VirtualThreadExecutor("tomcat-handler-"));
        }
        return connector;
    }
}

