/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.tomcat;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.servlet.engine.DefaultMicronautServlet;
import io.micronaut.servlet.engine.MicronautServletConfiguration;
import io.micronaut.servlet.engine.server.ServletServerFactory;
import io.micronaut.servlet.engine.server.ServletStaticResourceConfiguration;
import io.micronaut.servlet.tomcat.TomcatConfiguration;
import jakarta.inject.Singleton;
import jakarta.servlet.Servlet;
import java.io.File;
import java.util.List;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class TomcatFactory
extends ServletServerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatFactory.class);

    protected TomcatFactory(ResourceResolver resourceResolver, TomcatConfiguration serverConfiguration, SslConfiguration sslConfiguration, ApplicationContext applicationContext, List<ServletStaticResourceConfiguration> staticResourceConfigurations) {
        super(resourceResolver, (HttpServerConfiguration)serverConfiguration, sslConfiguration, applicationContext, staticResourceConfigurations);
    }

    public TomcatConfiguration getServerConfiguration() {
        return (TomcatConfiguration)super.getServerConfiguration();
    }

    @Singleton
    @Primary
    protected Tomcat tomcatServer(Connector connector, MicronautServletConfiguration configuration) {
        configuration.setAsyncFileServingEnabled(false);
        Tomcat tomcat = new Tomcat();
        tomcat.setHostname(this.getConfiguredHost());
        String contextPath = this.getContextPath();
        tomcat.getHost().setAutoDeploy(false);
        tomcat.setConnector(connector);
        String cp = contextPath != null && !contextPath.equals("/") ? contextPath : "";
        Context context = tomcat.addContext(cp, "/");
        File docBaseFile = new File(context.getDocBase());
        if (!docBaseFile.isAbsolute()) {
            docBaseFile = new File(((Host)context.getParent()).getAppBaseFile(), docBaseFile.getPath());
        }
        docBaseFile.mkdirs();
        Wrapper servlet = Tomcat.addServlet((Context)context, (String)configuration.getName(), (Servlet)new DefaultMicronautServlet(this.getApplicationContext()));
        Boolean isAsync = (Boolean)this.getApplicationContext().getEnvironment().getProperty("micronaut.server.testing.async", Boolean.class, (Object)true);
        if (Boolean.FALSE.equals(isAsync)) {
            LOG.warn("Async support disabled for testing purposes.");
        }
        servlet.setAsyncSupported(isAsync.booleanValue());
        servlet.addMapping(configuration.getMapping());
        this.getStaticResourceConfigurations().forEach(config -> servlet.addMapping(config.getMapping()));
        configuration.getMultipartConfigElement().ifPresent(arg_0 -> ((Wrapper)servlet).setMultipartConfigElement(arg_0));
        SslConfiguration sslConfiguration = this.getSslConfiguration();
        if (sslConfiguration.isEnabled()) {
            String protocol = sslConfiguration.getProtocol().orElse("TLS");
            int sslPort = sslConfiguration.getPort();
            if (sslPort == 8443 && this.getEnvironment().getActiveNames().contains("test")) {
                sslPort = 0;
            }
            Connector httpsConnector = new Connector();
            SSLHostConfig sslHostConfig = new SSLHostConfig();
            SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.UNDEFINED);
            sslHostConfig.addCertificate(certificate);
            httpsConnector.addSslHostConfig(sslHostConfig);
            httpsConnector.setPort(sslPort);
            httpsConnector.setSecure(true);
            httpsConnector.setScheme("https");
            httpsConnector.setProperty("clientAuth", "false");
            httpsConnector.setProperty("sslProtocol", protocol);
            httpsConnector.setProperty("SSLEnabled", "true");
            sslConfiguration.getCiphers().ifPresent(cyphers -> sslHostConfig.setCiphers(String.join((CharSequence)",", cyphers)));
            sslConfiguration.getClientAuthentication().ifPresent(ca -> httpsConnector.setProperty("clientAuth", ca == ClientAuthentication.WANT ? "want" : "true"));
            SslConfiguration.KeyStoreConfiguration keyStoreConfig = sslConfiguration.getKeyStore();
            keyStoreConfig.getPassword().ifPresent(arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeystorePassword(arg_0));
            keyStoreConfig.getPath().ifPresent(arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeystoreFile(arg_0));
            keyStoreConfig.getProvider().ifPresent(arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeystorePassword(arg_0));
            keyStoreConfig.getType().ifPresent(arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeystoreType(arg_0));
            SslConfiguration.TrustStoreConfiguration trustStore = sslConfiguration.getTrustStore();
            trustStore.getPassword().ifPresent(arg_0 -> ((SSLHostConfig)sslHostConfig).setTruststorePassword(arg_0));
            trustStore.getPath().ifPresent(arg_0 -> ((SSLHostConfig)sslHostConfig).setTruststoreFile(arg_0));
            trustStore.getProvider().ifPresent(arg_0 -> ((SSLHostConfig)sslHostConfig).setTruststoreProvider(arg_0));
            trustStore.getType().ifPresent(arg_0 -> ((SSLHostConfig)sslHostConfig).setTruststoreType(arg_0));
            SslConfiguration.KeyConfiguration keyConfig = sslConfiguration.getKey();
            keyConfig.getAlias().ifPresent(arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeyAlias(arg_0));
            keyConfig.getPassword().ifPresent(arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeyPassword(arg_0));
            tomcat.getService().addConnector(httpsConnector);
        }
        return tomcat;
    }

    @Singleton
    @Primary
    protected Connector tomcatConnector() {
        Connector tomcatConnector = this.getServerConfiguration().getTomcatConnector();
        tomcatConnector.setPort(this.getConfiguredPort().intValue());
        return tomcatConnector;
    }
}

