/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.tomcat;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.servlet.engine.DefaultMicronautServlet;
import io.micronaut.servlet.engine.MicronautServletConfiguration;
import io.micronaut.servlet.engine.initializer.MicronautServletInitializer;
import io.micronaut.servlet.http.server.ServletServerFactory;
import io.micronaut.servlet.http.server.ServletStaticResourceConfiguration;
import io.micronaut.servlet.tomcat.TomcatConfiguration;
import io.micronaut.web.router.Router;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletContainerInitializer;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardThreadExecutor;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;

@Factory
public class TomcatFactory
extends ServletServerFactory {
    private static final String HTTPS = "HTTPS";
    private static final String CLIENT_AUTH = "clientAuth";
    private final Router router;

    protected TomcatFactory(ResourceResolver resourceResolver, TomcatConfiguration serverConfiguration, SslConfiguration sslConfiguration, ApplicationContext applicationContext, List<ServletStaticResourceConfiguration> staticResourceConfigurations) {
        super(resourceResolver, (HttpServerConfiguration)serverConfiguration, sslConfiguration, applicationContext, staticResourceConfigurations);
        this.router = applicationContext.findBean(Router.class).orElse(null);
    }

    public TomcatConfiguration getServerConfiguration() {
        return (TomcatConfiguration)super.getServerConfiguration();
    }

    protected Tomcat tomcatServer(Connector connector, MicronautServletConfiguration configuration) {
        return this.tomcatServer(connector, (Connector)this.getApplicationContext().getBean(Connector.class, Qualifiers.byName((String)HTTPS)), configuration, this.getApplicationContext().getBeansOfType(ServletContainerInitializer.class));
    }

    @Singleton
    @Primary
    protected Tomcat tomcatServer(Connector connector, @Named(value="HTTPS") @Nullable Connector httpsConnector, MicronautServletConfiguration configuration, Collection<ServletContainerInitializer> servletInitializers) {
        configuration.setAsyncFileServingEnabled(false);
        Tomcat tomcat = this.newTomcat();
        if (configuration.getMaxThreads() != null) {
            StandardThreadExecutor executor = new StandardThreadExecutor();
            executor.setName("tomcatThreadPool");
            executor.setMaxThreads(configuration.getMaxThreads().intValue());
            if (configuration.getMinThreads() != null) {
                executor.setMinSpareThreads(configuration.getMinThreads().intValue());
            }
            tomcat.getService().addExecutor((org.apache.catalina.Executor)executor);
            if (connector != null) {
                connector.getProtocolHandler().setExecutor((Executor)executor);
            }
            if (httpsConnector != null) {
                httpsConnector.getProtocolHandler().setExecutor((Executor)executor);
            }
        }
        Context context = this.newTomcatContext(tomcat);
        this.configureServletInitializer(context, servletInitializers);
        this.configureConnectors(tomcat, connector, httpsConnector);
        TomcatConfiguration serverConfiguration = this.getServerConfiguration();
        serverConfiguration.getAccessLogConfiguration().ifPresent(accessValve -> {
            if (accessValve.isEnabled()) {
                Container[] children;
                for (Container child : children = tomcat.getHost().findChildren()) {
                    if (!(child instanceof ContainerBase)) continue;
                    ContainerBase containerBase = (ContainerBase)child;
                    containerBase.addValve((Valve)accessValve);
                }
            }
        });
        return tomcat;
    }

    protected void configureServletInitializer(Context context, Collection<ServletContainerInitializer> servletInitializers) {
        for (ServletContainerInitializer servletInitializer : servletInitializers) {
            if (servletInitializer instanceof MicronautServletInitializer) {
                MicronautServletInitializer micronautServletInitializer = (MicronautServletInitializer)servletInitializer;
                this.getStaticResourceConfigurations().forEach(config -> micronautServletInitializer.addMicronautServletMapping(config.getMapping()));
                context.addServletContainerInitializer(servletInitializer, Set.of(DefaultMicronautServlet.class));
                continue;
            }
            context.addServletContainerInitializer(servletInitializer, Set.of());
        }
    }

    protected void configureConnectors(@NonNull Tomcat tomcat, @NonNull Connector httpConnector, @Nullable Connector httpsConnector) {
        TomcatConfiguration serverConfiguration = this.getServerConfiguration();
        HttpVersion httpVersion = this.getServerConfiguration().getHttpVersion();
        if (httpVersion == HttpVersion.HTTP_2_0) {
            httpConnector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        }
        if (httpsConnector != null) {
            tomcat.getService().addConnector(httpsConnector);
            if (serverConfiguration.isDualProtocol()) {
                tomcat.getService().addConnector(httpConnector);
            }
            this.applyAdditionalPorts(tomcat, httpsConnector);
        } else {
            tomcat.setConnector(httpConnector);
            this.applyAdditionalPorts(tomcat, httpConnector);
        }
    }

    private void applyAdditionalPorts(Tomcat server, Connector serverConnector) {
        Set exposedPorts;
        if (this.router != null && CollectionUtils.isNotEmpty((Collection)(exposedPorts = this.router.getExposedPorts()))) {
            for (Integer exposedPort : exposedPorts) {
                if (exposedPort.equals(serverConnector.getLocalPort())) continue;
                Connector newConnector = TomcatFactory.cloneConnectorSettings(serverConnector);
                newConnector.setPort(exposedPort.intValue());
                server.getService().addConnector(newConnector);
            }
        }
    }

    private static Connector cloneConnectorSettings(Connector serverConnector) {
        SSLHostConfig[] sslHostConfigs;
        Connector newConnector = new Connector(serverConnector.getProtocol());
        ProtocolHandler protocolHandler = serverConnector.getProtocolHandler();
        for (SSLHostConfig sslHostConfig : sslHostConfigs = protocolHandler.findSslHostConfigs()) {
            newConnector.addSslHostConfig(sslHostConfig);
            newConnector.setSecure(true);
            newConnector.setScheme("https");
            newConnector.setProperty(CLIENT_AUTH, "false");
            newConnector.setProperty("sslProtocol", "TLS");
            newConnector.setProperty("SSLEnabled", "true");
        }
        newConnector.setAllowBackslash(serverConnector.getAllowBackslash());
        newConnector.setAllowTrace(serverConnector.getAllowTrace());
        newConnector.setAsyncTimeout(serverConnector.getAsyncTimeout());
        newConnector.setDiscardFacades(serverConnector.getDiscardFacades());
        newConnector.setEnableLookups(serverConnector.getEnableLookups());
        newConnector.setSecure(serverConnector.getSecure());
        newConnector.setScheme(serverConnector.getScheme());
        newConnector.setEnforceEncodingInGetWriter(serverConnector.getEnforceEncodingInGetWriter());
        newConnector.setMaxCookieCount(serverConnector.getMaxCookieCount());
        newConnector.setMaxPostSize(serverConnector.getMaxPostSize());
        newConnector.setMaxParameterCount(serverConnector.getMaxParameterCount());
        newConnector.setMaxSavePostSize(serverConnector.getMaxSavePostSize());
        newConnector.setParseBodyMethods(serverConnector.getParseBodyMethods());
        newConnector.setRejectSuspiciousURIs(serverConnector.getRejectSuspiciousURIs());
        newConnector.setUseIPVHosts(serverConnector.getUseIPVHosts());
        return newConnector;
    }

    @NonNull
    protected Context newTomcatContext(@NonNull Tomcat tomcat) {
        String contextPath = this.getContextPath();
        String cp = contextPath != null && !contextPath.equals("/") ? contextPath : "";
        Context context = tomcat.addContext(cp, "/");
        File docBaseFile = new File(context.getDocBase());
        if (!docBaseFile.isAbsolute()) {
            docBaseFile = new File(((Host)context.getParent()).getAppBaseFile(), docBaseFile.getPath());
        }
        docBaseFile.mkdirs();
        return context;
    }

    @NonNull
    protected Tomcat newTomcat() {
        Tomcat tomcat = new Tomcat();
        tomcat.getHost().setAutoDeploy(false);
        tomcat.setHostname(this.getConfiguredHost());
        return tomcat;
    }

    @Singleton
    @Primary
    protected Connector tomcatConnector() {
        Connector tomcatConnector = this.getServerConfiguration().getTomcatConnector();
        tomcatConnector.setPort(this.getConfiguredPort().intValue());
        return tomcatConnector;
    }

    @Singleton
    @Named(value="HTTPS")
    @Requires(property="micronaut.ssl.enabled", value="true")
    protected Connector sslConnector(SslConfiguration sslConfiguration) {
        String protocol = sslConfiguration.getProtocol().orElse("TLS");
        int sslPort = sslConfiguration.getPort();
        if (sslPort == 8443 && this.getEnvironment().getActiveNames().contains("test")) {
            sslPort = 0;
        }
        Connector httpsConnector = new Connector();
        SSLHostConfig sslHostConfig = new SSLHostConfig();
        SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.UNDEFINED);
        sslHostConfig.addCertificate(certificate);
        httpsConnector.addSslHostConfig(sslHostConfig);
        httpsConnector.setPort(sslPort);
        httpsConnector.setSecure(true);
        httpsConnector.setScheme("https");
        httpsConnector.setProperty(CLIENT_AUTH, "false");
        httpsConnector.setProperty("sslProtocol", protocol);
        httpsConnector.setProperty("SSLEnabled", "true");
        sslConfiguration.getCiphers().ifPresent(cyphers -> sslHostConfig.setCiphers(String.join((CharSequence)",", cyphers)));
        sslConfiguration.getClientAuthentication().ifPresent(ca -> httpsConnector.setProperty(CLIENT_AUTH, ca == ClientAuthentication.WANT ? "want" : "true"));
        SslConfiguration.KeyStoreConfiguration keyStoreConfig = sslConfiguration.getKeyStore();
        keyStoreConfig.getPassword().ifPresent(arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeystorePassword(arg_0));
        keyStoreConfig.getPath().ifPresent(arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeystoreFile(arg_0));
        keyStoreConfig.getProvider().ifPresent(arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeystorePassword(arg_0));
        keyStoreConfig.getType().ifPresent(arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeystoreType(arg_0));
        SslConfiguration.TrustStoreConfiguration trustStore = sslConfiguration.getTrustStore();
        trustStore.getPassword().ifPresent(arg_0 -> ((SSLHostConfig)sslHostConfig).setTruststorePassword(arg_0));
        trustStore.getPath().ifPresent(arg_0 -> ((SSLHostConfig)sslHostConfig).setTruststoreFile(arg_0));
        trustStore.getProvider().ifPresent(arg_0 -> ((SSLHostConfig)sslHostConfig).setTruststoreProvider(arg_0));
        trustStore.getType().ifPresent(arg_0 -> ((SSLHostConfig)sslHostConfig).setTruststoreType(arg_0));
        SslConfiguration.KeyConfiguration keyConfig = sslConfiguration.getKey();
        keyConfig.getAlias().ifPresent(arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeyAlias(arg_0));
        keyConfig.getPassword().ifPresent(arg_0 -> ((SSLHostConfigCertificate)certificate).setCertificateKeyPassword(arg_0));
        return httpsConnector;
    }
}

