/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.tomcat;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.event.ServerShutdownEvent;
import io.micronaut.servlet.http.server.AbstractServletServer;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;

@Singleton
public class TomcatServer
extends AbstractServletServer<Tomcat> {
    private final AtomicBoolean running = new AtomicBoolean(false);

    @Inject
    public TomcatServer(ApplicationContext applicationContext, ApplicationConfiguration applicationConfiguration, @Nullable ApplicationEventPublisher<ServerShutdownEvent> serverShutdownEventPublisher, Tomcat tomcat) {
        super(applicationContext, applicationConfiguration, serverShutdownEventPublisher, (Object)tomcat);
    }

    @Deprecated(forRemoval=true, since="5.2.0")
    public TomcatServer(ApplicationContext applicationContext, ApplicationConfiguration applicationConfiguration, Tomcat tomcat) {
        this(applicationContext, applicationConfiguration, null, tomcat);
    }

    protected void startServer() throws Exception {
        if (this.running.compareAndSet(false, true)) {
            Tomcat server = (Tomcat)this.getServer();
            server.start();
        }
    }

    protected void stopServer() throws Exception {
        if (this.running.compareAndSet(true, false)) {
            Tomcat tomcat = (Tomcat)this.getServer();
            tomcat.stop();
            tomcat.destroy();
        }
    }

    public int getPort() {
        Connector[] connectors = ((Tomcat)this.getServer()).getService().findConnectors();
        if (connectors.length == 1) {
            return ((Tomcat)this.getServer()).getConnector().getLocalPort();
        }
        return Arrays.stream(connectors).filter(Connector::getSecure).findFirst().map(Connector::getLocalPort).orElseGet(() -> ((Tomcat)this.getServer()).getConnector().getLocalPort());
    }

    public String getHost() {
        return ((Tomcat)this.getServer()).getHost().getName();
    }

    public String getScheme() {
        Connector[] connectors = ((Tomcat)this.getServer()).getService().findConnectors();
        if (connectors.length == 1) {
            return ((Tomcat)this.getServer()).getConnector().getScheme();
        }
        if (Arrays.stream(connectors).anyMatch(Connector::getSecure)) {
            return "https";
        }
        return "http";
    }

    public URL getURL() {
        try {
            return this.getURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new InternalServerException(e.getMessage(), (Throwable)e);
        }
    }

    public URI getURI() {
        return URI.create(this.getScheme() + "://" + this.getHost() + ":" + this.getPort());
    }

    public boolean isRunning() {
        return this.running.get();
    }
}

