/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.undertow;

import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.http.server.HttpServerConfiguration;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.xnio.Option;

@ConfigurationProperties(value="undertow")
@TypeHint(value={UndertowOptions.class, Option.class}, accessType={TypeHint.AccessType.ALL_DECLARED_FIELDS})
public class UndertowConfiguration
extends HttpServerConfiguration {
    @ConfigurationBuilder
    protected Undertow.Builder undertowBuilder = Undertow.builder();
    private final HttpServerConfiguration.MultipartConfiguration multipartConfiguration;
    private Map<String, String> workerOptions = new HashMap<String, String>(5);
    private Map<String, String> socketOptions = new HashMap<String, String>(5);
    private Map<String, String> serverOptions = new HashMap<String, String>(5);

    public UndertowConfiguration(@Nullable HttpServerConfiguration.MultipartConfiguration multipartConfiguration) {
        this.multipartConfiguration = multipartConfiguration;
    }

    public Undertow.Builder getUndertowBuilder() {
        return this.undertowBuilder;
    }

    public Optional<HttpServerConfiguration.MultipartConfiguration> getMultipartConfiguration() {
        return Optional.ofNullable(this.multipartConfiguration);
    }

    public Map<String, String> getWorkerOptions() {
        return this.workerOptions;
    }

    public void setWorkerOptions(@MapFormat(keyFormat=StringConvention.UNDER_SCORE_SEPARATED, transformation=MapFormat.MapTransformation.FLAT) Map<String, String> workerOptions) {
        if (workerOptions != null) {
            this.workerOptions.putAll(workerOptions);
        }
    }

    public Map<String, String> getSocketOptions() {
        return this.socketOptions;
    }

    public void setSocketOptions(@MapFormat(keyFormat=StringConvention.UNDER_SCORE_SEPARATED, transformation=MapFormat.MapTransformation.FLAT) Map<String, String> socketOptions) {
        if (socketOptions != null) {
            this.socketOptions.putAll(socketOptions);
        }
    }

    public Map<String, String> getServerOptions() {
        return this.serverOptions;
    }

    public void setServerOptions(@MapFormat(keyFormat=StringConvention.UNDER_SCORE_SEPARATED, transformation=MapFormat.MapTransformation.FLAT) Map<String, String> serverOptions) {
        if (serverOptions != null) {
            this.serverOptions.putAll(serverOptions);
        }
    }
}

